/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.censor.trie;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.openantivirus.engine.censor.Censor;
import org.openantivirus.engine.censor.MalwareFoundException;
import org.openantivirus.engine.censor.PositionFoundEvent;
import org.openantivirus.engine.censor.PositionFoundListener;
import org.openantivirus.engine.censor.ScanException;
import org.openantivirus.engine.censor.trie.Trie;
import org.openantivirus.engine.censor.trie.TrieNode;
import org.openantivirus.engine.vfs.VfsEntry;

public class TrieCensor
implements Censor {
    private static final int BUFFER_SIZE = 32768;
    private TrieNode nRoot;
    private TrieNode nCurrent;

    public TrieCensor(Trie trie) {
        this.nRoot = trie.getRootNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int censor(VfsEntry entry) throws MalwareFoundException, ScanException {
        this.nCurrent = this.nRoot;
        try {
            FileInputStream is = new FileInputStream(entry.getFile());
            try {
                this.scanStream(entry, is);
            }
            finally {
                ((InputStream)is).close();
            }
            return 1;
        }
        catch (IOException ioe) {
            throw new ScanException(ioe);
        }
    }

    protected void scanStream(VfsEntry entry, InputStream is) throws IOException, MalwareFoundException {
        byte[] abBuffer = new byte[98304];
        int iLength = this.fillBuffer(is, abBuffer, 0, abBuffer.length);
        if (iLength == -1) {
            return;
        }
        if (iLength < abBuffer.length) {
            this.update(entry, 0L, abBuffer, 0, iLength, 0, 0);
        } else {
            this.update(entry, 0L, abBuffer, 0, 65536, 0, 32768);
            long fileOffset = 65536L;
            int iBufferPos = 65536;
            int iReadAheadPos = 0;
            do {
                this.update(entry, fileOffset, abBuffer, iBufferPos, 32768, 32768, (iLength = this.fillBuffer(is, abBuffer, iReadAheadPos, 32768)) != -1 ? iLength : 0);
                iBufferPos = iReadAheadPos;
                if ((iReadAheadPos += 32768) >= 98304) {
                    iReadAheadPos -= 98304;
                }
                fileOffset += 32768L;
            } while (iLength == 32768);
            if (iLength != -1) {
                this.update(entry, fileOffset, abBuffer, iBufferPos, iLength, 32768, 0);
            }
        }
    }

    protected void update(VfsEntry entry, long fileOffset, byte[] ab, int iOffset, int iLength, int iPrefix, int iSuffix) throws MalwareFoundException {
        for (int i = iOffset; i < iOffset + iLength; ++i) {
            this.nCurrent = this.nCurrent.getTrans(ab[i] & 0xFF);
            if (!this.nCurrent.isLastNode()) continue;
            int iPosition = i - 3 + 1;
            PositionFoundEvent pfe = new PositionFoundEvent(entry, fileOffset + (long)iPosition, ab, iPosition, 3, iPosition - iOffset + iPrefix, iOffset + iLength - iPosition + iSuffix);
            Iterator it = this.nCurrent.getStringSearchListener().iterator();
            while (it.hasNext()) {
                ((PositionFoundListener)it.next()).positionFound(pfe);
            }
            this.nCurrent = this.nCurrent.getFailure();
        }
    }

    protected int fillBuffer(InputStream stream, byte[] buffer, int offset, int length) throws IOException {
        int iLength;
        int iRead = 0;
        do {
            if ((iLength = stream.read(buffer, offset + iRead, length - iRead)) != -1) continue;
            return iRead == 0 ? -1 : iRead;
        } while ((iRead += iLength) < length);
        return iRead;
    }
}

