/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.censor.trie;

import java.util.LinkedList;
import org.openantivirus.engine.censor.Censor;
import org.openantivirus.engine.censor.PositionFoundListener;
import org.openantivirus.engine.censor.StringSearch;
import org.openantivirus.engine.censor.trie.TrieCensor;
import org.openantivirus.engine.censor.trie.TrieNode;

public class Trie
implements StringSearch {
    public static final int MINIMUM_LENGTH = 3;
    private TrieNode nRoot = new TrieNode();
    private int[] nodeDepthCount = new int[3];

    public void addString(byte[] abPattern, PositionFoundListener pfl) {
        if (abPattern.length < 3) {
            throw new IllegalArgumentException("String too short");
        }
        TrieNode nPos = this.nRoot;
        for (int i = 0; i < 3; ++i) {
            TrieNode next;
            int iCharacter = abPattern[i] & 0xFF;
            TrieNode trieNode = next = nPos.isLastNode() ? null : nPos.getTrans(iCharacter);
            if (next == null) {
                next = new TrieNode();
                nPos.setTrans(iCharacter, next);
                int n = i;
                this.nodeDepthCount[n] = this.nodeDepthCount[n] + 1;
            }
            nPos = next;
        }
        nPos.addPositionFoundListener(pfl);
    }

    public TrieNode getRootNode() {
        return this.nRoot;
    }

    public void prepare() {
        LinkedList<TrieNode> children = new LinkedList<TrieNode>();
        this.nRoot.setFailure(null);
        for (int i = 0; i < 256; ++i) {
            TrieNode child = this.nRoot.getTrans(i);
            if (child == null) {
                this.nRoot.setTrans(i, this.nRoot);
                continue;
            }
            child.setFailure(this.nRoot);
            children.addLast(child);
        }
        while (!children.isEmpty()) {
            TrieNode node = (TrieNode)children.removeFirst();
            if (node.isLastNode()) continue;
            for (int i = 0; i < 256; ++i) {
                TrieNode child = node.getTrans(i);
                if (child == null) {
                    node.setTrans(i, node.getFailure().getTrans(i));
                    continue;
                }
                child.setFailure(node.getFailure().getTrans(i));
                children.addLast(child);
            }
        }
    }

    public int[] getNodeDepths() {
        return this.nodeDepthCount;
    }

    public Censor createCensor() {
        return new TrieCensor(this);
    }
}

