/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.censor.matcharray;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openantivirus.engine.censor.Censor;
import org.openantivirus.engine.censor.MalwareFoundException;
import org.openantivirus.engine.censor.PositionFoundEvent;
import org.openantivirus.engine.censor.PositionFoundListener;
import org.openantivirus.engine.censor.ScanException;
import org.openantivirus.engine.vfs.VfsEntry;

public class MatchArrayCensor
implements Censor {
    private static final int BUFFER_SIZE = 32768;
    private final PositionFoundListener[][] matchArray;
    private final PositionFoundEvent pfe = new PositionFoundEvent();
    private int match;

    public MatchArrayCensor(PositionFoundListener[][] matchArray) {
        this.matchArray = matchArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int censor(VfsEntry entry) throws MalwareFoundException, ScanException {
        try {
            FileInputStream is = new FileInputStream(entry.getFile());
            try {
                this.scanStream(entry, is);
            }
            finally {
                ((InputStream)is).close();
            }
            return 1;
        }
        catch (IOException ioe) {
            throw new ScanException(ioe);
        }
    }

    protected void scanStream(VfsEntry entry, InputStream is) throws IOException, MalwareFoundException {
        byte[] abBuffer = new byte[98304];
        int iLength = this.fillBuffer(is, abBuffer, 0, abBuffer.length);
        if (iLength == -1) {
            return;
        }
        this.match = abBuffer[0] & 0xFF;
        if (iLength < abBuffer.length) {
            this.update(entry, 1L, abBuffer, 1, iLength - 1, 1, 0);
        } else {
            this.update(entry, 1L, abBuffer, 1, 65535, 1, Short.MAX_VALUE);
            long fileOffset = 65536L;
            int iBufferPos = 65536;
            int iReadAheadPos = 0;
            do {
                this.update(entry, fileOffset, abBuffer, iBufferPos, 32768, 32768, (iLength = this.fillBuffer(is, abBuffer, iReadAheadPos, 32768)) != -1 ? iLength : 0);
                iBufferPos = iReadAheadPos;
                if ((iReadAheadPos += 32768) >= 98304) {
                    iReadAheadPos -= 98304;
                }
                fileOffset += 32768L;
            } while (iLength == 32768);
            if (iLength != -1) {
                this.update(entry, fileOffset, abBuffer, iBufferPos, iLength, 32768, 0);
            }
        }
    }

    protected void update(VfsEntry entry, long fileOffset, byte[] ab, int iOffset, int iLength, int iPrefix, int iSuffix) throws MalwareFoundException {
        int prefix = iOffset + iPrefix;
        int scanLength = iOffset + iLength;
        int postfix = scanLength + iSuffix;
        for (int i = iOffset; i < scanLength; ++i) {
            this.match = (this.match << 8 ^ ab[i]) & 0xFFFF;
            PositionFoundListener[] matchListener = this.matchArray[this.match];
            if (matchListener == null) continue;
            int iPosition = i - 1;
            this.pfe.setValues(entry, fileOffset + (long)iPosition, ab, iPosition, 2, iPosition - prefix, postfix - iPosition);
            for (int j = 0; j < matchListener.length; ++j) {
                matchListener[j].positionFound(this.pfe);
            }
        }
    }

    protected int fillBuffer(InputStream stream, byte[] buffer, int offset, int length) throws IOException {
        int iLength;
        int iRead = 0;
        do {
            if ((iLength = stream.read(buffer, offset + iRead, length - iRead)) != -1) continue;
            return iRead == 0 ? -1 : iRead;
        } while ((iRead += iLength) < length);
        return iRead;
    }
}

