/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.censor.matcharray;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.openantivirus.engine.censor.Censor;
import org.openantivirus.engine.censor.PositionFoundListener;
import org.openantivirus.engine.censor.StringSearch;
import org.openantivirus.engine.censor.matcharray.MatchArrayCensor;

public class MatchArray
implements StringSearch {
    public static final int MINIMUM_LENGTH = 2;
    private Collection[] colMatches = new Collection[65536];
    private PositionFoundListener[][] matches = new PositionFoundListener[65536][];

    public void addString(byte[] abPattern, PositionFoundListener pfl) {
        if (abPattern.length < 2) {
            throw new IllegalArgumentException("String too short");
        }
        int match = (abPattern[0] << 8 ^ abPattern[1]) & 0xFFFF;
        LinkedList<PositionFoundListener> colMatch = this.colMatches[match];
        if (colMatch == null) {
            this.colMatches[match] = colMatch = new LinkedList<PositionFoundListener>();
        }
        colMatch.add(pfl);
    }

    public Censor createCensor() {
        return new MatchArrayCensor(this.matches);
    }

    public void prepare() {
        for (int i = 0; i < this.colMatches.length; ++i) {
            Collection matchListener = this.colMatches[i];
            if (matchListener == null) continue;
            PositionFoundListener[] matchList = new PositionFoundListener[matchListener.size()];
            this.matches[i] = matchList;
            int j = 0;
            Iterator it = matchListener.iterator();
            while (it.hasNext()) {
                matchList[j++] = (PositionFoundListener)it.next();
            }
            this.colMatches[i] = null;
        }
    }
}

