/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.censor;

import java.util.StringTokenizer;
import org.openantivirus.engine.censor.MalwareFoundException;
import org.openantivirus.engine.censor.PositionFoundEvent;
import org.openantivirus.engine.censor.PositionFoundListener;
import org.openantivirus.engine.censor.StringSearch;
import org.openantivirus.engine.credo.WildcardPattern;

public class StringFinder {
    private final StringSearch stringSearch;
    private int multipartCount = 0;

    public StringFinder(StringSearch stringSearch) {
        this.stringSearch = stringSearch;
    }

    public void addString(String sPattern, final int offset, final PositionFoundListener pfl) {
        final byte[] pattern = new WildcardPattern((String)sPattern).pattern;
        byte[] searchPattern = new byte[pattern.length - offset];
        System.arraycopy(pattern, offset, searchPattern, 0, searchPattern.length);
        this.stringSearch.addString(searchPattern, new PositionFoundListener(){

            public void positionFound(PositionFoundEvent pfe) throws MalwareFoundException {
                if (StringFinder.checkString(pattern, offset, pfe)) {
                    StringFinder.adjustPosition(offset, pattern, pfe);
                    pfl.positionFound(pfe);
                }
            }
        });
    }

    public void addWildcardString(final WildcardPattern wp, final int offset, final PositionFoundListener pfl) {
        byte[] searchPattern = new byte[wp.pattern.length - offset];
        System.arraycopy(wp.pattern, offset, searchPattern, 0, searchPattern.length);
        this.stringSearch.addString(searchPattern, new PositionFoundListener(){

            public void positionFound(PositionFoundEvent pfe) throws MalwareFoundException {
                if (StringFinder.checkWildcardString(wp, offset, pfe)) {
                    StringFinder.adjustPosition(offset, wp.pattern, pfe);
                    pfl.positionFound(pfe);
                }
            }
        });
    }

    public void addMultipartString(String pattern, String offsets, final PositionFoundListener pfl) {
        StringTokenizer stOffsets = new StringTokenizer(offsets, "*");
        final int partCount = stOffsets.countTokens();
        final int multipartId = this.multipartCount++;
        int part = 1;
        StringTokenizer stPatterns = new StringTokenizer(pattern, "*");
        while (stPatterns.hasMoreTokens()) {
            final WildcardPattern subPattern = new WildcardPattern(stPatterns.nextToken());
            final int subOffset = Integer.parseInt(stOffsets.nextToken());
            byte[] searchPattern = new byte[subPattern.pattern.length - subOffset];
            System.arraycopy(subPattern.pattern, subOffset, searchPattern, 0, searchPattern.length);
            final int partId = part++;
            this.stringSearch.addString(searchPattern, new PositionFoundListener(){

                public void positionFound(PositionFoundEvent pfe) throws MalwareFoundException {
                    int foundPart;
                    int[] foundParts = pfe.entry.foundParts;
                    if (foundParts == null) {
                        pfe.entry.foundParts = foundParts = new int[StringFinder.this.multipartCount];
                    }
                    if ((foundPart = foundParts[multipartId]) != partId - 1) {
                        return;
                    }
                    if (StringFinder.checkWildcardString(subPattern, subOffset, pfe)) {
                        if (partId == partCount) {
                            pfl.positionFound(new PositionFoundEvent(pfe.entry, -1L, null, -1, -1, -1, -1));
                        } else {
                            pfe.entry.foundParts[multipartId] = partId;
                        }
                    }
                }
            });
        }
    }

    protected static void adjustPosition(int offset, byte[] pattern, PositionFoundEvent pfe) {
        pfe.bufferOffset -= offset;
        pfe.fileOffset -= (long)offset;
        pfe.length = pattern.length;
        pfe.prefix -= offset;
        pfe.suffix += pattern.length - offset - 2;
    }

    public static boolean checkString(byte[] pattern, int offset, PositionFoundEvent pfe) {
        if (pfe.fileOffset < (long)offset) {
            return false;
        }
        int iBufferPos = pfe.bufferOffset - offset;
        if (iBufferPos < 0) {
            iBufferPos += pfe.buffer.length;
        }
        int iSuffixEnd = pfe.bufferOffset + pfe.suffix;
        for (int i = 0; i < pattern.length; ++i) {
            if (iBufferPos == iSuffixEnd) {
                return false;
            }
            if (pattern[i] != pfe.buffer[iBufferPos]) {
                return false;
            }
            if (++iBufferPos != pfe.buffer.length) continue;
            iBufferPos -= pfe.buffer.length;
        }
        return true;
    }

    public static boolean checkWildcardString(WildcardPattern wp, int offset, PositionFoundEvent pfe) {
        if (pfe.fileOffset < (long)offset) {
            return false;
        }
        int iBufferPos = pfe.bufferOffset - offset;
        if (iBufferPos < 0) {
            iBufferPos += pfe.buffer.length;
        }
        int iSuffixEnd = pfe.bufferOffset + pfe.suffix;
        int skipIndex = 0;
        int skipCount = wp.skipList[0];
        for (int i = 0; i < wp.pattern.length; ++i) {
            if (iBufferPos == iSuffixEnd) {
                return false;
            }
            if (skipCount == 0) {
                skipCount = wp.skipList[++skipIndex];
                i += skipCount;
                if ((iBufferPos += skipCount) >= pfe.buffer.length) {
                    iBufferPos -= pfe.buffer.length;
                }
                skipCount = wp.skipList[++skipIndex];
            }
            --skipCount;
            if (wp.pattern[i] != pfe.buffer[iBufferPos]) {
                return false;
            }
            if (++iBufferPos != pfe.buffer.length) continue;
            iBufferPos -= pfe.buffer.length;
        }
        return true;
    }
}

