/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.openantivirus.engine.ScanConfiguration;

public class WriteableScanConfiguration
implements ScanConfiguration {
    private static final Collection BOOLEAN_SETTINGS = Arrays.asList("engine.halt-on-malware-found", "engine.use-trie", "vfs.follow-symlinks", "vfs.archive.enable", "vfs.archive.ace", "vfs.archive.ar", "vfs.archive.arc", "vfs.archive.arj", "vfs.archive.bzip2", "vfs.archive.cab", "vfs.archive.compress", "vfs.archive.cpio", "vfs.archive.dact", "vfs.archive.dar", "vfs.archive.gzip", "vfs.archive.lha", "vfs.archive.lzo", "vfs.archive.ppmd", "vfs.archive.rar", "vfs.archive.rpm", "vfs.archive.shar", "vfs.archive.tar", "vfs.archive.tnef", "vfs.archive.upx", "vfs.archive.uuencode", "vfs.archive.zip", "vfs.archive.zoo");
    private static final Collection INT_SETTINGS = Arrays.asList("credo.level");
    private static final Collection STRING_SETTINGS = Arrays.asList("credo.directory", "engine.tempdirectory");
    private Map properties = new HashMap();
    private final ScanConfiguration parent;

    protected WriteableScanConfiguration() {
        this.parent = null;
    }

    public WriteableScanConfiguration(ScanConfiguration parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent may not be null");
        }
        this.parent = parent;
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.getObject(key);
    }

    public String getString(String key) {
        return (String)this.getObject(key);
    }

    public int getInt(String key) {
        return (Integer)this.getObject(key);
    }

    public Object getObject(String key) {
        Object result = this.properties.get(key);
        if (result != null) {
            return result;
        }
        if (this.parent != null) {
            return this.parent.getObject(key);
        }
        throw new IllegalArgumentException("unknown key '" + key + "'");
    }

    public void putObject(String key, Object value) {
        this.properties.put(key, value);
    }

    public void putBoolean(String key, boolean value) {
        this.putObject(key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void putString(String key, String value) {
        this.putObject(key, value);
    }

    public void putInt(String key, int value) {
        this.putObject(key, new Integer(value));
    }

    public void putAny(String key, String value) {
        if (BOOLEAN_SETTINGS.contains(key)) {
            this.putBoolean(key, "yes".equals(value));
        } else if (INT_SETTINGS.contains(key)) {
            this.putInt(key, Integer.parseInt(value));
        } else if (STRING_SETTINGS.contains(key)) {
            this.putString(key, value);
        } else {
            System.err.println("Unknown key: " + key);
        }
    }

    public void loadFile(String filename) throws IOException {
        Properties settings = new Properties();
        settings.load(new FileInputStream(filename));
        Iterator<Map.Entry<Object, Object>> it = settings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> setting = it.next();
            this.putAny((String)setting.getKey(), (String)setting.getValue());
        }
    }
}

