/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openantivirus.engine.DefaultScanConfiguration;
import org.openantivirus.engine.ScanAbortedException;
import org.openantivirus.engine.ScanConfiguration;
import org.openantivirus.engine.ScanListener;
import org.openantivirus.engine.censor.CensorFactory;
import org.openantivirus.engine.censor.MalwareFoundException;
import org.openantivirus.engine.censor.StringSearch;
import org.openantivirus.engine.censor.matcharray.MatchArray;
import org.openantivirus.engine.censor.trie.Trie;
import org.openantivirus.engine.credo.CredoException;
import org.openantivirus.engine.credo.CredoParser;
import org.openantivirus.engine.vfs.VfsContainer;
import org.openantivirus.engine.vfs.VfsContainerFactory;
import org.openantivirus.engine.vfs.VfsEntry;
import org.openantivirus.engine.vfs.container.CompressedContainerFactory;
import org.openantivirus.engine.vfs.container.DirectoryContainerFactory;
import org.openantivirus.engine.vfs.entry.FileVfsEntry;

public class ScanEngine {
    private final VfsContainerFactory[] containerFactories = new VfsContainerFactory[]{new DirectoryContainerFactory(), new CompressedContainerFactory()};
    private final CensorFactory[] censorFactories = new CensorFactory[1];
    private final List scanListeners = new LinkedList();
    private final ScanConfiguration scanConfiguration;

    public ScanEngine() throws IOException, CredoException {
        this(new DefaultScanConfiguration());
    }

    public ScanEngine(ScanConfiguration scanConfiguration) throws IOException, CredoException {
        this.scanConfiguration = scanConfiguration;
        this.loadCredoFiles(scanConfiguration);
    }

    public void loadCredoFiles(ScanConfiguration scanConfiguration) throws CredoException, IOException {
        StringSearch stringSearch = scanConfiguration.getBoolean("engine.use-trie") ? new Trie() : new MatchArray();
        new CredoParser(scanConfiguration, stringSearch).parse(new File(scanConfiguration.getString("credo.directory")));
        stringSearch.prepare();
        this.censorFactories[0] = stringSearch;
        System.gc();
    }

    public void scan(File file) throws MalwareFoundException, IOException {
        this.scan(file, this.scanConfiguration);
    }

    public void scan(File file, ScanConfiguration conf) throws MalwareFoundException, IOException {
        this.notifyStartingScan();
        try {
            this.scan(new FileVfsEntry(file), conf);
        }
        catch (ScanAbortedException scanAbortedException) {
            // empty catch block
        }
        this.notifyFinishedScan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan(VfsEntry entry, ScanConfiguration conf) throws MalwareFoundException, ScanAbortedException {
        try {
            this.notifyScanning(entry);
            if (this.scanContainer(entry, conf)) {
                return;
            }
            for (int i = 0; i < this.censorFactories.length; ++i) {
                try {
                    int result = this.censorFactories[i].createCensor().censor(entry);
                    if (result != 2) continue;
                    return;
                }
                catch (MalwareFoundException mfe) {
                    this.notifyMalwareFound(mfe);
                    if (!conf.getBoolean("engine.halt-on-malware-found")) continue;
                    throw mfe;
                }
                catch (Exception e) {
                    this.notifyException(e);
                }
            }
        }
        finally {
            try {
                entry.dispose();
            }
            catch (IOException ioe) {
                this.notifyException(ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean scanContainer(VfsEntry entry, ScanConfiguration conf) throws MalwareFoundException {
        boolean containerFound = false;
        VfsContainer container = null;
        try {
            for (int i = 0; i < this.containerFactories.length && !containerFound; ++i) {
                try {
                    container = this.containerFactories[i].getContainer(entry, conf);
                    if (container == null) continue;
                    containerFound = true;
                    while (container.hasNext()) {
                        try {
                            this.scan(container.next(), conf);
                        }
                        catch (MalwareFoundException mfe) {
                            throw mfe;
                        }
                        catch (Exception e) {
                            this.notifyException(e);
                        }
                    }
                    container.dispose();
                    continue;
                }
                catch (MalwareFoundException mfe) {
                    throw mfe;
                }
                catch (Exception e) {
                    this.notifyException(e);
                }
            }
            Object var8_11 = null;
            if (!containerFound || container == null) return containerFound;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (!containerFound || container == null) throw throwable;
            try {
                container.dispose();
                throw throwable;
            }
            catch (IOException ioe) {
                this.notifyException(ioe);
            }
            throw throwable;
        }
        try {
            container.dispose();
            return containerFound;
        }
        catch (IOException ioe) {
            this.notifyException(ioe);
        }
        return containerFound;
    }

    public void addScanListener(ScanListener listener) {
        this.scanListeners.add(listener);
    }

    public void removeScanListener(ScanListener listener) {
        this.scanListeners.remove(listener);
    }

    protected void notifyStartingScan() {
        Iterator it = this.scanListeners.iterator();
        while (it.hasNext()) {
            ((ScanListener)it.next()).startingScan();
        }
    }

    protected void notifyScanning(VfsEntry entry) throws ScanAbortedException {
        Iterator it = this.scanListeners.iterator();
        while (it.hasNext()) {
            ((ScanListener)it.next()).scanning(entry);
        }
    }

    protected void notifyException(Exception exception) {
        Iterator it = this.scanListeners.iterator();
        while (it.hasNext()) {
            ((ScanListener)it.next()).exceptionThrown(exception);
        }
    }

    protected void notifyMalwareFound(MalwareFoundException mfe) {
        Iterator it = this.scanListeners.iterator();
        while (it.hasNext()) {
            ((ScanListener)it.next()).malwareFound(mfe);
        }
    }

    protected void notifyFinishedScan() {
        Iterator it = this.scanListeners.iterator();
        while (it.hasNext()) {
            ((ScanListener)it.next()).finishedScan();
        }
    }
}

