/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.daemon;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.openantivirus.daemon.RequestHandler;
import org.openantivirus.engine.DefaultScanConfiguration;
import org.openantivirus.engine.ScanConfiguration;
import org.openantivirus.engine.ScanEngine;
import org.openantivirus.engine.WriteableScanConfiguration;
import org.openantivirus.engine.credo.CredoException;

public class ScannerDaemon {
    public static final String REVISION = "0.6.0";
    public static final String BINDNAME = "localhost";
    public static final int PORT = 8127;
    private static final String CONF_FILE = "ScannerDaemon-settings.properties";
    private static final int MAX_BACKLOG = 50;
    private boolean isRunning;
    private final ScanConfiguration scanConf;
    private final ScanEngine engine;

    public ScannerDaemon(ScanConfiguration scanConfiguration) throws CredoException, IOException {
        this.engine = new ScanEngine(scanConfiguration);
        this.scanConf = scanConfiguration;
    }

    public void start() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(8127, 50, InetAddress.getByName(BINDNAME));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        System.out.println("Listening for incoming requests");
        this.isRunning = true;
        while (this.isRunning) {
            try {
                new Thread(new RequestHandler(serverSocket.accept(), this.engine, this.scanConf)).start();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("OpenAntivirus ScannerDaemon v0.6.0\n(c) 2001-2004 iKu Systemhaus AG http://www.iku-ag.de/\nScannerDaemon comes with ABSOLUTELY NO WARRANTY; for details read 'COPYING'.\nThis is free software, and you are welcome to redistribute it under certain\nconditions; for details read 'COPYING'.");
        WriteableScanConfiguration loadConf = new WriteableScanConfiguration(new DefaultScanConfiguration());
        WriteableScanConfiguration scanConf = new WriteableScanConfiguration(loadConf);
        try {
            boolean confFileLoaded = false;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].charAt(0) == '-') {
                    String sParameter = args[i].substring(1);
                    if ("nosignature".equals(sParameter)) {
                        scanConf.putInt("credo.level", -1);
                        continue;
                    }
                    if ("configfile".equals(sParameter)) {
                        loadConf.loadFile(args[++i]);
                        confFileLoaded = true;
                        continue;
                    }
                    scanConf.putAny(sParameter, args[++i]);
                    continue;
                }
                System.err.println("unknown parameter: " + args[i]);
            }
            if (!confFileLoaded && new File(CONF_FILE).exists()) {
                loadConf.loadFile(CONF_FILE);
            }
            new ScannerDaemon(scanConf).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

