/*
 * $Id: StopScanAction.java,v 1.3 2002/05/20 13:10:00 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.virushammer;

import java.awt.event.*;

import org.openantivirus.scanner.*;

/**
 * StopScanAction
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.3 $
 */
public class StopScanAction extends PerformableAction {
    public static final String VERSION =
        "$Id: StopScanAction.java,v 1.3 2002/05/20 13:10:00 kurti Exp $";
    
    /** Holds value of property scannerThread. */
    private ScannerThread scannerThread;
    
    private ScannerListener scannerListener = new ScannerListener() {
        public void startingScan() {
            updateEnabled();
        }
        
        public void finishedScan() {
            updateEnabled();
        }
        
        public void exceptionThrown(Exception exception) {}
        public void virusFound(VirusFoundException virusFoundException) {}        
    };
    
    public StopScanAction() {
        super(L10N.getString("Stop_scanning"));
    }
    
    public void actionPerformed(ActionEvent actionEvent) {
        scannerThread.stopScanning();
    }    
    
    /** @returns if this action should be enabled  */
    public boolean isPerformable() {
        return    (scannerThread != null)
               && (scannerThread.isScanning());
    }
    
    /** Setter for property scannerThread.
     * @param scannerThread New value of property scannerThread.
     */
    public void setScannerThread(ScannerThread scannerThread) {
        if (scannerThread != null) {
            scannerThread.removeScannerListener(scannerListener);
        }
        this.scannerThread = scannerThread;
        scannerThread.addScannerListener(scannerListener);
        updateEnabled();
    }
}
