/*
 * $Id: StatusModel.java,v 1.2 2002/04/10 16:29:28 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.virushammer;

import java.beans.*;

/**
 * StatusModel
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.2 $
 */
public class StatusModel {
    public static final String VERSION =
        "$Id: StatusModel.java,v 1.2 2002/04/10 16:29:28 kurti Exp $";
    
    /** Scanner-status */
    public static final int
            IDLE     = 0,
            SCANNING = 1;
    
    /** Holds value of property text. */
    private String text;
    
    /** Utility field used by bound properties. */
    private PropertyChangeSupport propertyChangeSupport =
            new PropertyChangeSupport(this);
    
    /** Holds value of property scanning. */
    private int scanning;
    
    /** Adds a PropertyChangeListener to the listener list.
     * @param l The listener to add.
     */
    public void addPropertyChangeListener(String property,
                                          PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(property, l);
    }
    
    /** Removes a PropertyChangeListener from the listener list.
     * @param l The listener to remove.
     */
    public void removePropertyChangeListener(String property,
                                          PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(property, l);
    }
    
    /** Getter for property text.
     * @return Value of property text.
     */
    public String getText() {
        return this.text;
    }
    
    /** Setter for property text.
     * @param text New value of property text.
     */
    public void setText(String text) {
        String oldText = this.text;
        this.text = text;
        propertyChangeSupport.firePropertyChange("text", oldText, text);
    }
    
    /** Getter for property scanning.
     * @return Value of property scanning.
     */
    public int getScanning() {
        return this.scanning;
    }
    
    /** Setter for property scanning.
     * @param scanning New value of property scanning.
     */
    public void setScanning(int scanning) {
        int oldScanning = this.scanning;
        this.scanning = scanning;
        propertyChangeSupport.firePropertyChange("scanning", new Integer(oldScanning), new Integer(scanning));
    }
}
