/*
 * $Id: StartScanAction.java,v 1.3 2002/05/20 13:10:00 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.virushammer;

import java.awt.event.*;
import java.io.*;
import javax.swing.event.*;

import org.openantivirus.scanner.*;

/**
 * StartScanAction
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.3 $
 */
public class StartScanAction extends PerformableAction {
    public static final String VERSION =
        "$Id: StartScanAction.java,v 1.3 2002/05/20 13:10:00 kurti Exp $";
    
    /** Holds value of property scanTargetList. */
    private ScanTargetList scanTargetList = null;
    
    /** Listener on items being added or removed */
    private ListDataListener scanTargetListener = new ListDataListener() {
        public void intervalAdded(ListDataEvent lde) {
            updateEnabled();
        }
        
        public void intervalRemoved(ListDataEvent lde) {
            updateEnabled();
        }
        
        public void contentsChanged(ListDataEvent lde) {
            updateEnabled();
        }
    };
    
    private ScannerListener scannerListener = new ScannerListener() {
        public void startingScan() {
            updateEnabled();
        }
        
        public void finishedScan() {
            updateEnabled();
        }
        
        public void exceptionThrown(Exception exception) {}
        public void virusFound(VirusFoundException virusFoundException) {}        
    };
    
    /** Holds value of property scannerThread. */
    private ScannerThread scannerThread;
    
    public StartScanAction() {
        super(L10N.getString("Start_scanning"));
    }
    
    public void actionPerformed(ActionEvent actionEvent) {
        scannerThread.startScanning();
    }    
    
    /** @returns if this action should be enabled  */
    public boolean isPerformable() {
        return    (scanTargetList != null)
               && (scannerThread  != null)
               && (!scannerThread.isScanning())
               && (scanTargetList.getSize() > 0);
    }
    
    /** Setter for property scanTargetList.
     * @param scanTargetList New value of property scanTargetList.
     */
    public void setScanTargetList(ScanTargetList scanTargetList) {
        if (scanTargetList != null) {
            scanTargetList.removeListDataListener(scanTargetListener);
        }
        this.scanTargetList = scanTargetList;
        if (scanTargetList != null) {
            scanTargetList.addListDataListener(scanTargetListener);
        }
        updateEnabled();
    }
    
    /** Setter for property scannerThread.
     * @param scannerThread New value of property scannerThread.
     */
    public void setScannerThread(ScannerThread scannerThread) {
        if (scannerThread != null) {
            scannerThread.removeScannerListener(scannerListener);
        }
        this.scannerThread = scannerThread;
        scannerThread.addScannerListener(scannerListener);
        updateEnabled();
    }
}
