/*
 * $Id: ScanTarget.java,v 1.2 2002/04/10 16:29:27 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.virushammer;

import java.io.*;

/**
 * A target to scan regulary
 *
 * Pattern-Roles: Container
 * @author  Kurt Huwig
 * @version $Revision: 1.2 $
 */
public class ScanTarget {
    public static final String VERSION =
        "$Id: ScanTarget.java,v 1.2 2002/04/10 16:29:27 kurti Exp $";
    
    /** Holds value of property path. */
    private File path;    
    
    /** Holds value of property subfolders. */
    private boolean subfolders;
    
    public ScanTarget() {}
    
    public ScanTarget(File path, boolean subfolders) {
        this.path       = path;
        this.subfolders = subfolders;
    }
    
    /** Getter for property path.
     * @return Value of property path.
     */
    public File getPath() {
        return this.path;
    }
    
    /** Setter for property path.
     * @param path New value of property path.
     */
    public void setPath(File path) {
        this.path = path;
    }
    
    public String toString() {
        return path.getAbsolutePath();
    }
    
    /** Getter for property subfolders.
     * @return Value of property subfolders.
     */
    public boolean getSubfolders() {
        return this.subfolders;
    }
    
    /** Setter for property subfolders.
     * @param subfolders New value of property subfolders.
     */
    public void setSubfolders(boolean subfolders) {
        this.subfolders = subfolders;
    }
    
}
