package org.openantivirus.virushammer;

import java.awt.event.ActionEvent;

/**
 * RemoveTargetAction
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Id: RemoveTargetAction.java,v 1.2 2002/04/10 16:29:27 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2001 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class RemoveTargetAction extends PerformableAction {
    public static final String VERSION =
        "$Id: RemoveTargetAction.java,v 1.2 2002/04/10 16:29:27 kurti Exp $";
    
    /** Holds value of property scanTarget. */
    private ScanTarget scanTarget = null;
    
    /** Holds value of property scanTargetList. */
    private ScanTargetList scanTargetList;
    
    public RemoveTargetAction() {
        super(L10N.getString("Remove"));
    }
    
    /**
     * Invoked when an action occurs.
     */
    public void actionPerformed(ActionEvent e) {
        scanTargetList.removeScanTarget(scanTarget);
        setScanTarget(null);
    }    
    
    /** @returns if this action should be enabled  */
    public boolean isPerformable() {
        return    (scanTarget     != null)
               && (scanTargetList != null);
    }
    
    /** Setter for property scanTarget.
     * @param scanTarget New value of property scanTarget.
     */
    public void setScanTarget(ScanTarget scanTarget) {
        this.scanTarget = scanTarget;
        updateEnabled();
    }
    
    /** Setter for property scanTargetList.
     * @param scanTargetList New value of property scanTargetList.
     */
    public void setScanTargetList(ScanTargetList scanTargetList) {
        this.scanTargetList = scanTargetList;
        updateEnabled();
    }
    
}
