package org.openantivirus.virushammer;

import javax.swing.*;
import java.beans.*;

/**
 * PropertyChangeAction
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Id: PerformableAction.java,v 1.2 2002/04/10 16:29:27 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2001 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public abstract class PerformableAction extends AbstractAction {
    public static final String VERSION =
        "$Id: PerformableAction.java,v 1.2 2002/04/10 16:29:27 kurti Exp $";
    
    public PerformableAction(String text) {
        super(text);
        updateEnabled();
    }
    
    /**
     * sets the action to enabled/disabled, according to the result of
     * isPerformable(); this method should be called after the internal state
     * of the action has changed in a way that can affect the performability
     */
    protected void updateEnabled() {
        setEnabled(isPerformable());
    }
    
    /** @returns if this action should be enabled */
    public abstract boolean isPerformable();
}
