/*
 * $Id: L10N.java,v 1.2 2002/04/10 16:29:27 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.virushammer;

import java.util.*;

/**
 * L10N support
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.2 $
 */
public class L10N {
    public static final String VERSION =
        "$Id: L10N.java,v 1.2 2002/04/10 16:29:27 kurti Exp $";
    
    private static ResourceBundle bundle;
    
    /** sets the bundle to be used */
    public static void setResourceBundle(ResourceBundle bundle) {
        L10N.bundle = bundle;
    }
    
    /** @returns the localized string for this key or an error message */
    public static String getString(String name) {
        try {
            return bundle.getString(name);
        } catch (MissingResourceException mre) {
            final String errorMsg =
                    "*** Missing translation for '" + name + "' ***";
            mre.printStackTrace();
            return errorMsg;
        }
    }
    
    /**
     * @returns the Mnemonic-character for the appropriate String, either from
     *          the ResourceBundle or the first character of the String
     */
    public static char getMnemonic(String name) {
        try {
            return bundle.getString(name + "Mnemonic").charAt(0);
        } catch (MissingResourceException mre) {
            return getString(name).charAt(0);
        }
    }
    
}
