/*
 * $Id: ExitAction.java,v 1.2 2002/04/10 16:29:27 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2001 iKu Netzwerkl&ouml;sungen
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.virushammer;

import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;

/**
 * ExitAction
 *
 * Pattern-Roles: 
 * @author  Kurt Huwig
 * @version $Revision: 1.2 $
 */
public class ExitAction extends PerformableAction {
    public static final String VERSION =
        "$Id: ExitAction.java,v 1.2 2002/04/10 16:29:27 kurti Exp $";
    
    /** Holds value of property scanTargetList. */
    private ScanTargetList scanTargetList;
    
    public ExitAction() {
        super(L10N.getString("Exit"));
    }
    
    public void actionPerformed(ActionEvent actionEvent) {
        final Properties appProperties = new Properties();
        final StringBuffer sb = new StringBuffer();
        
        if (scanTargetList.getSize() > 0) {
            sb.append(scanTargetList.getElementAt(0));
        }
        for (int i = 1; i < scanTargetList.getSize(); i++) {
            sb.append(File.pathSeparatorChar);
            sb.append(scanTargetList.getElementAt(i));
        }
            
        appProperties.setProperty("scantargets", sb.toString());
        
        try {
            final FileOutputStream fos = new FileOutputStream(
                    System.getProperty("user.home") + File.separatorChar
                    + "VirusHammer.properties");
            appProperties.store(fos, "VirusHammer");
            fos.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
    
    /** @returns if this action should be enabled  */
    public boolean isPerformable() {
        return scanTargetList != null;
    }
    
    /** Setter for property scanTargetList.
     * @param scanTargetList New value of property scanTargetList.
     */
    public void setScanTargetList(ScanTargetList scanTargetList) {
        this.scanTargetList = scanTargetList;
        updateEnabled();
    }
    
}
