/*
 * $Id: AddTargetAction.java,v 1.2 2002/04/10 16:29:27 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.virushammer;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.util.*;
import javax.swing.*;

/**
 * Opens a filedialog to add a target to the targetlist, the selected file
 * (if any) is fired via a PropertyChangeEvent.
 *
 * Pattern-Roles: 
 * @author  Kurt Huwig
 * @version $Revision: 1.2 $
 */
public class AddTargetAction extends PerformableAction {
    public static final String VERSION =
        "$Id: AddTargetAction.java,v 1.2 2002/04/10 16:29:27 kurti Exp $";
    
    /** Holds value of property selectedFile. */
    private File selectedFile;
    
    /** Holds value of property scanTargetList. */
    private ScanTargetList scanTargetList;
    
    public AddTargetAction() {
        super(L10N.getString("Add") + "...");
    }
    
    public void actionPerformed(ActionEvent actionEvent) {
        final JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
        fc.setApproveButtonText(L10N.getString("Add"));
        fc.setApproveButtonMnemonic(L10N.getMnemonic("Add"));
        fc.setDialogTitle(L10N.getString("Add_scan_target"));
        if (fc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
            File file = fc.getSelectedFile();
            if (!file.exists()) {
                file = file.getParentFile();
            }
            scanTargetList.addScanTarget(new ScanTarget(file,
                                                        file.isDirectory()));
        }
    }
    
    /** @returns if this action should be enabled  */
    public boolean isPerformable() {
        return scanTargetList != null;
    }
    
    /** Setter for property scanTargetList.
     * @param scanTargetList New value of property scanTargetList.
     */
    public void setScanTargetList(ScanTargetList scanTargetList) {
        this.scanTargetList = scanTargetList;
        updateEnabled();
    }
    
}
