/*
 * $Id: PESection.java,v 1.1 2002/05/13 22:21:01 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.ucl;

/**
 * Section of a PE file
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.1 $
 */
public class PESection extends CStructure {
    public static final String VERSION =
        "$Id: PESection.java,v 1.1 2002/05/13 22:21:01 kurti Exp $";
    
    public static final int SIZE = 40;
    
    /** Offsets */
    private static final int
        VADDRESS         = 12,
        RAW_DATA_POINTER = 20;
    
    /** Maximum length of section name */
    private static final int MAX_NAME_LENGTH = 8;
    
    public PESection(byte[] data) {
        super(data, SIZE);
    }
    
    public long getVAddress() {
        return getLE32(VADDRESS);
    }
    
    public String getName() {
        final StringBuffer sb = new StringBuffer();
        for (int i = 0; i < MAX_NAME_LENGTH; i++) {
            final int value = getByte(i);
            if (value == 0) {
                break;
            }
            sb.append((char) value);
        }
        return sb.toString();
    }
    
    public long getRawDataPointer() {
        return getLE32(RAW_DATA_POINTER);
    }
}
