/*
 * $Id: EXEHeader.java,v 1.1 2002/05/13 22:21:01 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.ucl;

/**
 * EXEHeader
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.1 $
 */
public class EXEHeader extends CStructure {
    public static final String VERSION =
        "$Id: EXEHeader.java,v 1.1 2002/05/13 22:21:01 kurti Exp $";

    public static final int SIZE = 64;
    
    /** Offsets */
    private static final int
        MZ                = 0,
        M512              = 2,
        P512              = 4,
        RELOCATION_OFFSET = 24,
        NEXT_E_POSITION   = 60;

    public EXEHeader(byte[] data) {
        super(data, SIZE);
    }

    public int getMZ() {
        return getLE16(MZ);
    }

    public int getM512() {
        return getLE16(M512);
    }

    public int getP512() {
        return getLE16(P512);
    }

    public int getRelocationOffset() {
        return getLE16(RELOCATION_OFFSET);
    }

    public long getNextEPos() {
        return getLE32(NEXT_E_POSITION);
    }
}
