/*
 * $Id: CStructure.java,v 1.1 2002/05/13 22:21:01 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.ucl;

/**
 * Wrapper to decode a C 'struct'
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.1 $
 */
public class CStructure {
    public static final String VERSION =
        "$Id: CStructure.java,v 1.1 2002/05/13 22:21:01 kurti Exp $";
    
    private final byte[] data;
    
    public CStructure(byte[] data, int size) {
        this.data = data;
        if (data.length != size) {
            throw new IllegalArgumentException("Datasize must be "
                                               + size);
        }
    }
    
    public int getByte(int index) {
        return getByte(data, index);
    }
    
    public int getLE16(int index) {
        return getLE16(data, index);
    }
    
    public long getLE32(int index) {
        return getLE32(data, index);
    }
    
    public static int getByte(byte[] data, int index) {
        return ((data[index] + 256) & 0xff);
    }
    
    public static int getLE16(byte[] data, int index) {
        return (getByte(data, index) | (getByte(data, index + 1) << 8));
    }

    public static int getBE16(byte[] data, int index) {
        return (getByte(data, index + 1) | (getByte(data, index) << 8));
    }

    public static int getLE24(byte[] data, int index) {
        return ((int) getLE16(data, index)
                + (((int) getByte(data, index + 2)) << 16));
    }

    public static long getLE32(byte[] data, int index) {
        return ((long) getLE16(data, index)
                + (((long) getLE16(data, index + 2)) << 16));
    }
    
    public static long getBE32(byte[] data, int index) {
        return ((long) getBE16(data, index + 2)
                + (((long) getBE16(data, index)) << 16));
    }
}
