/*
 * $Id: ScanObject.java,v 1.2 2002/05/20 13:10:35 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.scanner.scanobject;

import java.io.*;

/**
 * Represents an object to be scanned for viruses
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.2 $
 */
public abstract class ScanObject {
    public static final String VERSION =
        "$Id: ScanObject.java,v 1.2 2002/05/20 13:10:35 kurti Exp $";
    
    /** Maximum size of the start array */
    public static final int MAX_START_SIZE = 2048;
    
    /** Holds value of property recursive. */
    private boolean recursive = true;
    
    /** Holds value of property haltOnError. */
    private boolean haltOnError = true;
    
    /** Holds value of property haltOnVirusFound. */
    private boolean haltOnVirusFound = true;
    
    /**
     * @return the first block of bytes from the object; should be at least 2kB
     */
    public abstract byte[] getStart() throws IOException;
    
    /** @return File for the object; the caller HAS TO close all streams to it */
    public abstract File getFile() throws IOException;
    
    /** called if the ScanObject is not needed any more */
    public abstract void dispose() throws IOException;
    
    /** Getter for property recursive.
     * @return Value of property recursive.
     */
    public boolean isRecursive() {
        return this.recursive;
    }
    
    /** Setter for property recursive.
     * @param recursive New value of property recursive.
     */
    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }
    
    /** Getter for property haltOnError.
     * @return Value of property haltOnError.
     */
    public boolean getHaltOnError() {
        return this.haltOnError;
    }
    
    /** Setter for property haltOnError.
     * @param haltOnError New value of property haltOnError.
     */
    public void setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }
    
    /** Getter for property haltOnVirusFound.
     * @return Value of property haltOnVirusFound.
     */
    public boolean getHaltOnVirusFound() {
        return this.haltOnVirusFound;
    }
    
    /** Setter for property haltOnVirusFound.
     * @param haltOnVirusFound New value of property haltOnVirusFound.
     */
    public void setHaltOnVirusFound(boolean haltOnVirusFound) {
        this.haltOnVirusFound = haltOnVirusFound;
    }
    
}
