/*
 * $Id: FileScanObject.java,v 1.2 2002/05/20 13:10:35 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.scanner.scanobject;

import java.io.*;

/**
 * FileScanObject
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.2 $
 */
public class FileScanObject extends ScanObject {
    public static final String VERSION =
        "$Id: FileScanObject.java,v 1.2 2002/05/20 13:10:35 kurti Exp $";
    
    private final File file;
    
    /** lazy initialized array with the start of the file */
    private byte[] start = null;
    
    public FileScanObject(File file) {
        this.file = file;
    }
    
    public File getFile() {
        return file;
    }
    
    /** called if the ScanObject is not needed any more  */
    public void dispose() throws IOException {
        start = null;
    }    
    
    /** @return the first block of bytes from the object; should be at least 2kB
     */
    public byte[] getStart() throws IOException {
        if (start == null) {
            final RandomAccessFile raf = new RandomAccessFile(file, "r");
            start = new byte[Math.min(MAX_START_SIZE, (int) file.length())];
            raf.readFully(start);
            raf.close();
        }
        return start;
    }
}
