/*
 * $Id: ZipFilter.java,v 1.2 2002/05/20 13:10:35 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.scanner.filter;

import java.io.*;
import java.util.*;
import java.util.zip.*;
import org.openantivirus.scanner.*;
import org.openantivirus.scanner.scanobject.*;

/**
 * Filters ZIP files into ScanObjects for their entries
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.2 $
 */
public class ZipFilter implements Filter {
    public static final String VERSION =
        "$Id: ZipFilter.java,v 1.2 2002/05/20 13:10:35 kurti Exp $";
    
    private static ZipFilter instance = null;
    
    protected ZipFilter() {}
    
    /**
     * Filters the scanObject into other scanObjects and hands them over
     * to the scanner
     */
    public void filter(ScanObject scanObject, Scanner scanner)
                throws VirusFoundException, Exception {
        final ZipFile zipFile = new ZipFile(scanObject.getFile());
        for (Enumeration e = zipFile.entries(); e.hasMoreElements(); ) {
            final ZipEntry entry = (ZipEntry) e.nextElement();
            if (entry.isDirectory()) {
                continue;
            }
            
            scanner.scan(new TemporaryScanObject(
                    zipFile.getInputStream(entry),
                    scanner.getScannerConfiguration().getTempDirectory()));
        }
        zipFile.close();
    }
    
    /** some filters are thread-safe, so let them decide themselves  */
    public static ZipFilter getInstance() {
        if (instance == null) {
            instance = new ZipFilter();
        }
        
        return instance;
    }
    
}
