/*
 * $Id: UPXFilter.java,v 1.4 2002/10/16 12:25:47 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.scanner.filter;

import java.io.*;
import org.openantivirus.scanner.*;
import org.openantivirus.scanner.scanobject.*;
import org.openantivirus.ucl.*;

/**
 * UPXFilter
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.4 $
 */
public class UPXFilter implements Filter {
    public static final String VERSION =
        "$Id: UPXFilter.java,v 1.4 2002/10/16 12:25:47 kurti Exp $";
    
    private final RandomAccessFile raf;
    private final UPXDecompress upxDecompress;
    private final ScannerConfiguration scannerConfiguration;
    
    public UPXFilter(RandomAccessFile raf, UPXDecompress upxDecompress,
                     ScannerConfiguration scannerConfiguration) {
        this.raf                  = raf;
        this.upxDecompress        = upxDecompress;
        this.scannerConfiguration = scannerConfiguration;
    }
    
    /**
     * Filters the scanObject into other scanObjects and hands them over
     * to the scanner
     */
    public void filter(ScanObject scanObject, Scanner scanner)
            throws VirusFoundException, Exception {
        final ScanObject decompressed = new TemporaryScanObject(
                scannerConfiguration.getTempDirectory());
        final File decompressedFile = decompressed.getFile();
        final OutputStream os = new FileOutputStream(decompressedFile);
        upxDecompress.decompress(os);
        os.close();
        raf.close();
        // UPXDecompress does not generate correct exe files yet
        // scanner.scan(decompressed);
        try {
            // scan compressed file first due to patterns by PatternFinder
            new TrieScanFilter(scannerConfiguration.getTrie()).filter(
                    scanObject, scanner);
            new TrieScanFilter(scannerConfiguration.getTrie()).filter(
                    decompressed, scanner);
        } finally {
            decompressedFile.delete();
        }
    }
    
}
