/*
 * $Id: DirectoryFilter.java,v 1.2 2002/05/20 13:10:35 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.scanner.filter;

import java.io.*;
import org.openantivirus.scanner.*;
import org.openantivirus.scanner.scanobject.*;

/**
 * Filters all files in the given directory
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.2 $
 */
public class DirectoryFilter implements Filter {
    public static final String VERSION =
        "$Id: DirectoryFilter.java,v 1.2 2002/05/20 13:10:35 kurti Exp $";
    
    private static final DirectoryFilter instance = new DirectoryFilter();
    
    protected DirectoryFilter() {}
    
    public static DirectoryFilter getInstance() {
        return instance;
    }
    
    /**
     * Filters the scanObject into other scanObjects and hands them over
     * to the scanner
     */
    public void filter(ScanObject scanObject, Scanner scanner)
            throws VirusFoundException, Exception {
        File[] files = scanObject.getFile().listFiles();
        for (int i = 0; i < files.length; i++) {
            scanner.scan(new FileScanObject(files[i]));
        }
    }
}
