/*
 * $Id: StreamScanner.java,v 1.1 2001/12/12 23:59:38 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2001 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.scanner;

/**
 * Scans a stream for virii
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.1 $
 *
 */
public interface StreamScanner {
    String VERSION =
        "$Id: StreamScanner.java,v 1.1 2001/12/12 23:59:38 kurti Exp $";
    
    /**
     * Scans the next block of the stream for virii; blocks are expected to
     * appear in the correct order. The buffer is a ringbuffer, but the blocks
     * marked by offset/length have to be continuous. The prefix/postfix areas
     * may "wrap around". Prefix and postfix will have a resonable size (2048+
     * bytes) when possible.
     *
     * @param buffer buffer containing data to be scanned
     * @param offset offset of the first byte of data to be scanned
     * @param length length of the data to be scanned
     * @param prefix number of valid bytes before the index
     */
    public void update(byte[] buffer, int offset, int length,
                       int prefix, int postfix) throws VirusFoundException;
    
    /** resets the internal state of the scanner; usually at end of file */
    public void reset();
}
