/*
 * $Id: ScannerSuite.java,v 1.1 2001/12/12 23:59:38 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2001 iKu Netzwerkl&ouml;sungen
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.scanner;

import junit.framework.*;

/**
 * ScannerSuite
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.1 $
 */
public class ScannerSuite extends TestCase {
    public static final String VERSION =
        "$Id: ScannerSuite.java,v 1.1 2001/12/12 23:59:38 kurti Exp $";
    
    public ScannerSuite(java.lang.String testName) {
        super(testName);
    }        
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite() {
        TestSuite suite = new TestSuite("ScannerSuite");
        suite.addTest(org.openantivirus.scanner.TrieScannerTest.suite());
        suite.addTest(org.openantivirus.scanner.StringFinderTest.suite());
        return suite;
    }
}
