/*
 * $Id: Node.java,v 1.4 2002/10/16 11:01:44 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2001 iKu Netzwerkl&ouml;sungen
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.scanner;

import java.util.*;

import org.openantivirus.scanner.*;

/**
 * A knot in the trie
 *
 * @author  Kurt Huwig
 * @version $Revision: 1.4 $
 */
public class Node {
    public static final String VERSION =
        "$Id: Node.java,v 1.4 2002/10/16 11:01:44 kurti Exp $";

    /**
     * Number of children a node has; currently one for every possible byte
     * value
     */
    public final static int NUM_CHILDS = 256;
    
    private Node nFailure = null;
    private static int iInstances = 0;
    private boolean bIsLastNode = true;
    private Collection colPositionFoundListener = null;
    
    private Node[] anTrans = null;
    
    public Node() {
        iInstances++;
    }
    
    public void setTrans(int iByte, Node n) {
        if (anTrans == null) {
            anTrans = new Node[NUM_CHILDS];
            bIsLastNode = false;
        }
        anTrans[iByte] = n;
    }
    
    public Node getTrans(int index) {
        return anTrans[index];
    }
    
    public boolean isLastNode() {
        return bIsLastNode;
    }
    
    public void addPositionFoundListener(PositionFoundListener pfl) {
        if (colPositionFoundListener == null) {
            colPositionFoundListener = new LinkedList();
        }
        colPositionFoundListener.add(pfl);
    }
    
    public Collection getStringSearchListener() {
        return colPositionFoundListener;
    }
    
    public void setFailure(Node nFailure) {
        this.nFailure = nFailure;
    }
    
    public Node getFailure() {
        return nFailure;
    }

    public static int getInstanceCount() {
        return iInstances;
    }
}
