package org.openantivirus.credo;

import java.util.*;
import java.util.jar.*;
import java.io.*;

/**
 * CredoEntryIterator
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Id: CredoEntryIterator.java,v 1.1 2002/04/10 16:29:28 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2001 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
class CredoEntryIterator implements Iterator {
    public static final String VERSION =
        "$Id: CredoEntryIterator.java,v 1.1 2002/04/10 16:29:28 kurti Exp $";
    
    private final JarInputStream jarInputStream;
    
    /**
     * the next element to return or null if there is none
     */
    private Object nextElement = UNINITIALIZED;
    
    /** this value is set as 'nextElement' if 'hasNext' has not been called */
    private static final Object UNINITIALIZED = new Object();
    
    public CredoEntryIterator(JarInputStream jarInputStream) {
        this.jarInputStream = jarInputStream;
    }
    
    /**
     * Returns <tt>true</tt> if the iteration has more elements. (In other
     * words, returns <tt>true</tt> if <tt>next</tt> would return an element
     * rather than throwing an exception.)
     *
     * @return <tt>true</tt> if the iterator has more elements.
     */
    public boolean hasNext() {
        if (nextElement == UNINITIALIZED) {
            setNext();
        }
        return nextElement != null;
    }    
    
    /**
     * Returns the next element in the interation.
     *
     * @return the next element in the iteration.
     * @exception NoSuchElementException iteration has no more elements.
     */
    public Object next() {
        if (nextElement == UNINITIALIZED) {
            setNext();
        }
        if (nextElement == null) {
            throw new NoSuchElementException();
        }
        
        final Object result = nextElement;
        nextElement = UNINITIALIZED;
        return result;
    }
    
    /**
     *
     * Removes from the underlying collection the last element returned by the
     * iterator (optional operation).  This method can be called only once per
     * call to <tt>next</tt>.  The behavior of an iterator is unspecified if
     * the underlying collection is modified while the iteration is in
     * progress in any way other than by calling this method.
     *
     * @exception UnsupportedOperationException if the <tt>remove</tt>
     * 		  operation is not supported by this Iterator.
     *
     * @exception IllegalStateException if the <tt>next</tt> method has not
     * 		  yet been called, or the <tt>remove</tt> method has already
     * 		  been called after the last call to the <tt>next</tt>
     * 		  method.
     */
    public void remove() {
        throw new UnsupportedOperationException();
    }
    
    /**
     * sets the next element to the next element of the Enumeration or null,
     * if there is none
     */
    private void setNext() {
        JarEntry jarEntry;
        do {
            try {
                jarEntry = jarInputStream.getNextJarEntry();
            } catch (IOException ioe) {
                // happens at EOF
                jarEntry = null;
            }
        } while (jarEntry != null
                 && (jarEntry.isDirectory()
                     || jarEntry.getName().startsWith("META-INF/")));
        nextElement = (jarEntry != null
                       ? new CredoEntry(jarInputStream, jarEntry) : null);
    }
}
