/*
 * $Id: CredoEntry.java,v 1.1 2002/04/10 16:29:28 kurti Exp $
 *
 * This file is part of the OpenAntiVirus-Project,
 * see http://www.openantivirus.org/
 * (c) 2002 iKu Netzwerkl&ouml;sungen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openantivirus.credo;

import java.util.jar.*;
import java.io.*;

/**
 * An entry in a Credo file; it is a simple wrapper for JarEntry
 *
 * Pattern-Roles:
 * @author  Kurt Huwig
 * @version $Revision: 1.1 $
 */
public class CredoEntry {
    public static final String VERSION =
        "$Id: CredoEntry.java,v 1.1 2002/04/10 16:29:28 kurti Exp $";
    
    /**
     * Entry types
     */
    public static final int
        UNINITIALIZED = -1,
        UNKNOWN       = 0,
        STRINGS       = 1;
    
    /** containing file */
    private final JarInputStream jarInputStream;
    
    /** corresponding entry */
    private final JarEntry jarEntry;
    
    /** type of Entry; lazy initialization */
    private int type = UNINITIALIZED;
    
    public CredoEntry(JarInputStream jarInputStream, JarEntry jarEntry) {
        this.jarInputStream = jarInputStream;
        this.jarEntry       = jarEntry;
    }
    
    /**
     * @return InputStream of the entry's content
     */
    public InputStream getInputStream() throws IOException {
        return jarInputStream;
    }
    
    /**
     * @return type of entry
     */
    public int getType() {
        if (type == UNINITIALIZED) {
            final String name = jarEntry.getName();
            if (name.endsWith(".strings")) {
                type = STRINGS;
            } else {
                type = UNKNOWN;
            }
        }
        return type;
    }
    
    public JarEntry getJarEntry() {
        return jarEntry;
    }
}
