/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.ucl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.openantivirus.ucl.CStructure;
import org.openantivirus.ucl.EXEHeader;
import org.openantivirus.ucl.PEHeader;
import org.openantivirus.ucl.PESection;
import org.openantivirus.ucl.PackHeader;

public class UPXDecompress {
    private final RandomAccessFile raf;
    private final long file_size;
    private static final int MAX_IC = 20;
    private static final String UPX_SECTION_NAME = "UPX";
    private static final int MAX_VERSION = 12;
    private static final int M_NRV2B_LE32 = 2;
    private static final int M_NRV2B_8 = 3;
    private static final int M_NRV2B_LE16 = 4;
    private static final int M_NRV2D_LE32 = 5;
    private static final int M_NRV2D_8 = 6;
    private static final int M_NRV2D_LE16 = 7;
    private boolean isRTM;
    private long pe_offset;
    private PEHeader ih;
    private PESection[] isection;
    private final PackHeader ph = new PackHeader();
    int ilen;
    byte[] src;
    byte[] dst;
    long bitBuffer;
    int bitCount;

    public UPXDecompress(RandomAccessFile randomAccessFile, long l) {
        this.raf = randomAccessFile;
        this.file_size = l;
    }

    public boolean canUnpack() throws IOException {
        if (!this.readFileHeader()) {
            return false;
        }
        int n = this.ih.getObjects();
        if (n != 3) {
            return false;
        }
        this.isection = new PESection[n];
        this.raf.seek(this.pe_offset + 248L);
        int n2 = 0;
        while (n2 < this.isection.length) {
            byte[] byArray = new byte[40];
            this.raf.readFully(byArray);
            this.isection[n2] = new PESection(byArray);
            ++n2;
        }
        if (this.ih.getDDirsSize(15) == 0L && this.ih.getEntry() <= this.isection[1].getVAddress()) {
            return false;
        }
        if (this.isection[0].getName().startsWith(UPX_SECTION_NAME)) {
            return this.readPackHeader(1024, this.isection[1].getRawDataPointer() - 64L) || this.readPackHeader(1024, this.isection[2].getRawDataPointer());
        }
        return false;
    }

    protected boolean readPackHeader(int n, long l) throws IOException {
        if (n <= 0 || l < 0L) {
            return false;
        }
        byte[] byArray = new byte[n];
        this.raf.seek(l);
        this.raf.readFully(byArray);
        if (!this.ph.fillPackHeader(byArray)) {
            return false;
        }
        if (!this.ph.checkPackHeader(byArray)) {
            return false;
        }
        if (this.ph.getVersion() > 12) {
            throw new IOException("need a newer version of UPX");
        }
        if (this.ph.getCLength() >= this.ph.getULength() || (long)this.ph.getCLength() >= this.file_size) {
            throw new IOException("header corrupted");
        }
        if (this.ph.getMethod() < 2 || this.ph.getMethod() > 7) {
            throw new IOException("unknown compression method");
        }
        return true;
    }

    protected boolean readFileHeader() throws IOException {
        byte[] byArray;
        this.pe_offset = 0L;
        int n = 0;
        while (n < 20) {
            this.raf.seek(this.pe_offset);
            byArray = new byte[64];
            this.raf.readFully(byArray);
            EXEHeader eXEHeader = new EXEHeader(byArray);
            if (eXEHeader.getMZ() == 23117) {
                this.pe_offset = eXEHeader.getRelocationOffset() >= 64 ? (this.pe_offset += eXEHeader.getNextEPos()) : (this.pe_offset += (long)((eXEHeader.getP512() << 9) + eXEHeader.getM512() - (eXEHeader.getM512() != 0 ? 512 : 0)));
            } else {
                if (eXEHeader.getLE32(0) == 17744L) break;
                return false;
            }
            ++n;
        }
        if (n == 20) {
            return false;
        }
        byArray = new byte[248];
        this.raf.seek(this.pe_offset);
        this.raf.readFully(byArray);
        this.ih = new PEHeader(byArray);
        byte[] byArray2 = new byte["32STUB".length()];
        this.raf.seek(512L);
        this.raf.readFully(byArray2);
        this.isRTM = "32STUB".equals(new String(byArray2));
        return true;
    }

    public void decompress(OutputStream outputStream) throws IOException {
        if (this.ih == null) {
            throw new IllegalStateException("Need to call 'canUnpack()' first");
        }
        this.raf.seek(this.isection[1].getRawDataPointer() - 64L + (long)this.ph.getBufferOffset() + (long)this.ph.getPackHeaderSize());
        this.src = new byte[this.ph.getCLength()];
        this.raf.readFully(this.src);
        this.dst = new byte[this.ph.getULength()];
        this.bitBuffer = 0L;
        this.bitCount = 0;
        this.ilen = 0;
        int n = 0;
        int n2 = 1;
        while (true) {
            if (this.getbit() != 0) {
                this.dst[n++] = this.src[this.ilen++];
                continue;
            }
            long l = 1L;
            do {
                l = (l << 1) + (long)this.getbit();
            } while (this.getbit() == 0);
            if (l == 2L) {
                l = n2;
            } else {
                if ((l = (l - 3L << 8) + (long)CStructure.getByte(this.src, this.ilen++)) == 0xFFFFFFFFL) break;
                n2 = (int)(++l);
            }
            int n3 = this.getbit();
            n3 = (n3 << 1) + this.getbit();
            if (n3 == 0) {
                ++n3;
                do {
                    n3 = (n3 << 1) + this.getbit();
                } while (this.getbit() == 0);
                n3 += 2;
            }
            n3 += l > 3328L ? 1 : 0;
            int n4 = (int)((long)n - l);
            this.dst[n++] = this.dst[n4++];
            do {
                this.dst[n++] = this.dst[n4++];
            } while (--n3 > 0);
        }
        if (outputStream != null) {
            outputStream.write(this.dst);
        }
        if (this.ilen < this.src.length) {
            throw new IOException("UPX input not consumed");
        }
    }

    int getbit() throws IOException {
        if (this.bitCount > 0) {
            --this.bitCount;
            return (int)(this.bitBuffer >> this.bitCount & 1L);
        }
        this.bitCount = 31;
        this.bitBuffer = CStructure.getByte(this.src, this.ilen++) + (CStructure.getByte(this.src, this.ilen++) << 8) + (CStructure.getByte(this.src, this.ilen++) << 16) + (CStructure.getByte(this.src, this.ilen++) << 24);
        return (int)(this.bitBuffer >> 31 & 1L);
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File("/home/kurt/Virus/Fix2001-upx.exe");
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            UPXDecompress uPXDecompress = new UPXDecompress(randomAccessFile, file.length());
            System.out.println("canUnpack: " + uPXDecompress.canUnpack());
            FileOutputStream fileOutputStream = new FileOutputStream("/home/kurt/Virus/F2001.exe");
            uPXDecompress.decompress(fileOutputStream);
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

