/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.ucl;

import org.openantivirus.ucl.CStructure;

public class PackHeader {
    public static final String VERSION = "$Id: PackHeader.java,v 1.1 2002/05/13 22:21:01 kurti Exp $";
    private static final byte[] UPX_MAGIC_LE32 = new byte[]{85, 80, 88, 33};
    private static final int UPX_F_DOS_COM = 1;
    private static final int UPX_F_DOS_SYS = 2;
    private static final int UPX_F_DOS_EXE = 3;
    private static final int UPX_F_DOS_EXEH = 7;
    private int version;
    private int format;
    private int method;
    private int level;
    private int filter;
    private int filter_cto;
    private long u_adler;
    private long c_adler;
    private int u_len;
    private int c_len;
    private int u_file_size;
    private int buf_offset;

    public boolean fillPackHeader(byte[] byArray) {
        int n = this.find(byArray, UPX_MAGIC_LE32);
        if (n == -1) {
            return false;
        }
        this.buf_offset = n;
        this.version = CStructure.getByte(byArray, n + 4);
        this.format = CStructure.getByte(byArray, n + 5);
        this.method = CStructure.getByte(byArray, n + 6);
        this.level = CStructure.getByte(byArray, n + 7);
        this.filter_cto = 0;
        int n2 = 0;
        if (this.format < 128) {
            this.u_adler = CStructure.getLE32(byArray, n + 8);
            this.c_adler = CStructure.getLE32(byArray, n + 12);
            if (this.format == 1 || this.format == 2) {
                this.u_len = CStructure.getLE16(byArray, n + 16);
                this.c_len = CStructure.getLE16(byArray, n + 18);
                this.u_file_size = this.u_len;
                n2 = 20;
            } else if (this.format == 3 || this.format == 7) {
                this.u_len = CStructure.getLE24(byArray, n + 16);
                this.c_len = CStructure.getLE24(byArray, n + 19);
                this.u_file_size = CStructure.getLE24(byArray, n + 22);
                n2 = 25;
            } else {
                this.u_len = (int)CStructure.getLE32(byArray, n + 16);
                this.c_len = (int)CStructure.getLE32(byArray, n + 20);
                this.u_file_size = (int)CStructure.getLE32(byArray, n + 24);
                n2 = 28;
                this.filter_cto = CStructure.getByte(byArray, n + 29);
            }
        } else {
            this.u_len = (int)CStructure.getBE32(byArray, n + 8);
            this.c_len = (int)CStructure.getBE32(byArray, n + 12);
            this.u_adler = CStructure.getBE32(byArray, n + 16);
            this.c_adler = CStructure.getBE32(byArray, n + 20);
            this.u_file_size = (int)CStructure.getBE32(byArray, n + 24);
            n2 = 28;
            this.filter_cto = CStructure.getByte(byArray, n + 29);
        }
        if (this.version >= 10) {
            this.filter = CStructure.getByte(byArray, n + n2);
        } else if ((this.level & 0x80) == 0) {
            this.filter = 0;
        } else {
            this.level &= 0x7F;
            this.filter = this.format == 1 || this.format == 2 ? 6 : 38;
        }
        this.level &= 0xF;
        return true;
    }

    public boolean checkPackHeader(byte[] byArray) {
        if (this.version == 255) {
            System.out.println("cannot unpack UPX ;-)");
            return false;
        }
        int n = this.getPackHeaderSize();
        int n2 = byArray.length - this.buf_offset;
        if (n2 <= 0 || n > n2) {
            System.err.println("header corrupted");
            return false;
        }
        if (this.version > 9 && byArray[this.buf_offset + n - 1] != this.getPackHeaderChecksum(byArray, n - 1)) {
            System.err.println("header corrupted");
            return false;
        }
        return true;
    }

    public int getVersion() {
        return this.version;
    }

    public int getCLength() {
        return this.c_len;
    }

    public int getULength() {
        return this.u_len;
    }

    public int getMethod() {
        return this.method;
    }

    public int getBufferOffset() {
        return this.buf_offset;
    }

    protected byte getPackHeaderChecksum(byte[] byArray, int n) {
        int n2 = this.buf_offset;
        n2 += 4;
        n -= 4;
        int n3 = 0;
        while (n-- > 0) {
            n3 += CStructure.getByte(byArray, n2++);
        }
        return (byte)(n3 %= 251);
    }

    protected int getPackHeaderSize() {
        int n = 0;
        n = this.version <= 3 ? 24 : (this.version <= 9 ? (this.format == 1 || this.format == 2 ? 20 : (this.format == 3 || this.format == 7 ? 25 : 28)) : (this.format == 1 || this.format == 2 ? 22 : (this.format == 3 || this.format == 7 ? 27 : 32)));
        if (n == 0) {
            System.err.println("unknown header version");
        }
        return n;
    }

    protected int find(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n < byArray.length) {
            block3: {
                int n2 = 0;
                while (n2 < byArray2.length) {
                    if (byArray[n + n2] == byArray2[n2]) {
                        ++n2;
                        continue;
                    }
                    break block3;
                }
                return n;
            }
            ++n;
        }
        return -1;
    }
}

