/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.ucl;

public class CStructure {
    public static final String VERSION = "$Id: CStructure.java,v 1.1 2002/05/13 22:21:01 kurti Exp $";
    private final byte[] data;

    public CStructure(byte[] byArray, int n) {
        this.data = byArray;
        if (byArray.length != n) {
            throw new IllegalArgumentException("Datasize must be " + n);
        }
    }

    public int getByte(int n) {
        return CStructure.getByte(this.data, n);
    }

    public int getLE16(int n) {
        return CStructure.getLE16(this.data, n);
    }

    public long getLE32(int n) {
        return CStructure.getLE32(this.data, n);
    }

    public static int getByte(byte[] byArray, int n) {
        return byArray[n] + 256 & 0xFF;
    }

    public static int getLE16(byte[] byArray, int n) {
        return CStructure.getByte(byArray, n) | CStructure.getByte(byArray, n + 1) << 8;
    }

    public static int getBE16(byte[] byArray, int n) {
        return CStructure.getByte(byArray, n + 1) | CStructure.getByte(byArray, n) << 8;
    }

    public static int getLE24(byte[] byArray, int n) {
        return CStructure.getLE16(byArray, n) + (CStructure.getByte(byArray, n + 2) << 16);
    }

    public static long getLE32(byte[] byArray, int n) {
        return (long)CStructure.getLE16(byArray, n) + ((long)CStructure.getLE16(byArray, n + 2) << 16);
    }

    public static long getBE32(byte[] byArray, int n) {
        return (long)CStructure.getBE16(byArray, n + 2) + ((long)CStructure.getBE16(byArray, n) << 16);
    }
}

