/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner.scanobject;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.openantivirus.scanner.scanobject.ScanObject;

public class TemporaryScanObject
extends ScanObject {
    public static final String VERSION = "$Id: TemporaryScanObject.java,v 1.3 2002/05/20 13:10:35 kurti Exp $";
    private static final String TEMP_PREFIX = "file";
    private static final String TEMP_SUFFIX = "oav";
    private static final int BUFFER_SIZE = 8192;
    private final File file;
    private byte[] start = null;

    public TemporaryScanObject(File file) throws IOException {
        this.file = this.createTempFile(file);
    }

    public TemporaryScanObject(InputStream inputStream, File file) throws IOException {
        int n;
        this.file = this.createTempFile(file);
        FileOutputStream fileOutputStream = new FileOutputStream(this.file);
        int n2 = 0;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray, n2, 2048 - n2)) != -1) {
            ((OutputStream)fileOutputStream).write(byArray, n2, n);
            if ((n2 += n) == 2048) break;
        }
        this.start = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.start[n3] = byArray[n3];
            ++n3;
        }
        while ((n = inputStream.read(byArray)) != -1) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((OutputStream)fileOutputStream).close();
    }

    protected File createTempFile(File file) throws IOException {
        File file2 = File.createTempFile(TEMP_PREFIX, TEMP_SUFFIX, file);
        return file2;
    }

    public void dispose() throws IOException {
        this.file.delete();
    }

    public File getFile() throws IOException {
        return this.file;
    }

    public byte[] getStart() throws IOException {
        if (this.start == null) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "r");
            this.start = new byte[Math.min(2048, (int)this.file.length())];
            randomAccessFile.readFully(this.start);
        }
        return this.start;
    }
}

