/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner.filter;

import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openantivirus.scanner.Scanner;
import org.openantivirus.scanner.VirusFoundException;
import org.openantivirus.scanner.filter.Filter;
import org.openantivirus.scanner.scanobject.ScanObject;
import org.openantivirus.scanner.scanobject.TemporaryScanObject;

public class ZipFilter
implements Filter {
    public static final String VERSION = "$Id: ZipFilter.java,v 1.2 2002/05/20 13:10:35 kurti Exp $";
    private static ZipFilter instance = null;

    protected ZipFilter() {
    }

    public void filter(ScanObject scanObject, Scanner scanner) throws VirusFoundException, Exception {
        ZipFile zipFile = new ZipFile(scanObject.getFile());
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) continue;
            scanner.scan(new TemporaryScanObject(zipFile.getInputStream(zipEntry), scanner.getScannerConfiguration().getTempDirectory()));
        }
        zipFile.close();
    }

    public static ZipFilter getInstance() {
        if (instance == null) {
            instance = new ZipFilter();
        }
        return instance;
    }
}

