/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner.filter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.openantivirus.scanner.Scanner;
import org.openantivirus.scanner.ScannerConfiguration;
import org.openantivirus.scanner.VirusFoundException;
import org.openantivirus.scanner.filter.Filter;
import org.openantivirus.scanner.filter.TrieScanFilter;
import org.openantivirus.scanner.scanobject.ScanObject;
import org.openantivirus.scanner.scanobject.TemporaryScanObject;
import org.openantivirus.ucl.UPXDecompress;

public class UPXFilter
implements Filter {
    public static final String VERSION = "$Id: UPXFilter.java,v 1.4 2002/10/16 12:25:47 kurti Exp $";
    private final RandomAccessFile raf;
    private final UPXDecompress upxDecompress;
    private final ScannerConfiguration scannerConfiguration;

    public UPXFilter(RandomAccessFile randomAccessFile, UPXDecompress uPXDecompress, ScannerConfiguration scannerConfiguration) {
        this.raf = randomAccessFile;
        this.upxDecompress = uPXDecompress;
        this.scannerConfiguration = scannerConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ScanObject scanObject, Scanner scanner) throws VirusFoundException, Exception {
        TemporaryScanObject temporaryScanObject = new TemporaryScanObject(this.scannerConfiguration.getTempDirectory());
        File file = ((ScanObject)temporaryScanObject).getFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.upxDecompress.decompress(fileOutputStream);
        ((OutputStream)fileOutputStream).close();
        this.raf.close();
        try {
            new TrieScanFilter(this.scannerConfiguration.getTrie()).filter(scanObject, scanner);
            new TrieScanFilter(this.scannerConfiguration.getTrie()).filter(temporaryScanObject, scanner);
            Object var7_6 = null;
            file.delete();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            file.delete();
            throw throwable;
        }
    }
}

