/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner.filter;

import java.io.File;
import java.io.IOException;
import org.openantivirus.scanner.ScannerConfiguration;
import org.openantivirus.scanner.filter.DirectoryFilter;
import org.openantivirus.scanner.filter.Filter;
import org.openantivirus.scanner.filter.FilterFactory;
import org.openantivirus.scanner.filter.NullFilter;
import org.openantivirus.scanner.scanobject.ScanObject;

public class FileSystemFilterFactory
implements FilterFactory {
    public static final String VERSION = "$Id: FileSystemFilterFactory.java,v 1.2 2002/05/14 21:33:31 kurti Exp $";
    private final ScannerConfiguration scannerConfiguration;

    public FileSystemFilterFactory(ScannerConfiguration scannerConfiguration) {
        this.scannerConfiguration = scannerConfiguration;
    }

    public Filter getFilterFor(ScanObject scanObject) throws IOException {
        File file = scanObject.getFile();
        if (!this.scannerConfiguration.getFollowSymlinks() && !file.getAbsolutePath().equals(file.getCanonicalPath())) {
            return NullFilter.getInstance();
        }
        if (!file.canRead()) {
            return NullFilter.getInstance();
        }
        if (file.isDirectory()) {
            return DirectoryFilter.getInstance();
        }
        if (!file.isFile()) {
            return NullFilter.getInstance();
        }
        return null;
    }
}

