/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner.filter;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.openantivirus.scanner.ScannerConfiguration;
import org.openantivirus.scanner.filter.Filter;
import org.openantivirus.scanner.filter.FilterFactory;
import org.openantivirus.scanner.filter.TrieScanFilter;
import org.openantivirus.scanner.filter.UPXFilter;
import org.openantivirus.scanner.scanobject.ScanObject;
import org.openantivirus.ucl.UPXDecompress;

public class ExecutableFilterFactory
implements FilterFactory {
    public static final String VERSION = "$Id: ExecutableFilterFactory.java,v 1.2 2002/05/14 21:33:31 kurti Exp $";
    private final ScannerConfiguration scannerConfiguration;

    public ExecutableFilterFactory(ScannerConfiguration scannerConfiguration) {
        this.scannerConfiguration = scannerConfiguration;
    }

    public Filter getFilterFor(ScanObject scanObject) throws IOException {
        byte[] byArray = scanObject.getStart();
        if (byArray[0] == 77 && byArray[1] == 90) {
            boolean bl;
            File file = scanObject.getFile();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            UPXDecompress uPXDecompress = new UPXDecompress(randomAccessFile, file.length());
            try {
                bl = uPXDecompress.canUnpack();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
            }
            if (bl) {
                return new UPXFilter(randomAccessFile, uPXDecompress, this.scannerConfiguration);
            }
            randomAccessFile.close();
            return new TrieScanFilter(this.scannerConfiguration.getTrie());
        }
        return null;
    }
}

