/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner;

import java.util.Iterator;
import org.openantivirus.scanner.Node;
import org.openantivirus.scanner.PositionFoundEvent;
import org.openantivirus.scanner.PositionFoundListener;
import org.openantivirus.scanner.StreamScanner;
import org.openantivirus.scanner.Trie;
import org.openantivirus.scanner.VirusFoundException;

public class TrieScanner
implements StreamScanner {
    public static final String VERSION = "$Id: TrieScanner.java,v 1.2 2002/10/16 11:01:44 kurti Exp $";
    private Node nRoot;
    private Node nCurrent;

    public TrieScanner(Trie trie) {
        this.nRoot = trie.getRootNode();
        this.reset();
    }

    public void update(byte[] byArray, int n, int n2, int n3, int n4) throws VirusFoundException {
        int n5 = n;
        while (n5 < n + n2) {
            this.nCurrent = this.nCurrent.getTrans(byArray[n5] & 0xFF);
            if (this.nCurrent.isLastNode()) {
                int n6 = n5 - 4 + 1;
                PositionFoundEvent positionFoundEvent = new PositionFoundEvent(byArray, n6, 4, n6 - n + n3, n + n2 - n6 + n4 - 4);
                Iterator iterator = this.nCurrent.getStringSearchListener().iterator();
                while (iterator.hasNext()) {
                    PositionFoundListener positionFoundListener = (PositionFoundListener)iterator.next();
                    positionFoundListener.positionFound(positionFoundEvent);
                }
                this.nCurrent = this.nCurrent.getFailure();
            }
            ++n5;
        }
    }

    public void reset() {
        this.nCurrent = this.nRoot;
    }
}

