/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner;

import java.util.LinkedList;
import org.openantivirus.scanner.Node;
import org.openantivirus.scanner.PositionFoundListener;

public class Trie {
    public static final String VERSION = "$Id: Trie.java,v 1.5 2002/10/16 11:01:44 kurti Exp $";
    public static final int MINIMUM_LENGTH = 4;
    private Node nRoot = new Node();
    private int[] nodeDepthCount = new int[4];

    public void addString(byte[] byArray, PositionFoundListener positionFoundListener) {
        if (byArray.length < 4) {
            throw new IllegalArgumentException("String too short");
        }
        Node node = this.nRoot;
        int n = 0;
        while (n < 4) {
            Node node2;
            int n2 = byArray[n] + 256 & 0xFF;
            Node node3 = node2 = node.isLastNode() ? null : node.getTrans(n2);
            if (node2 == null) {
                node2 = new Node();
                node.setTrans(n2, node2);
                int n3 = n;
                this.nodeDepthCount[n3] = this.nodeDepthCount[n3] + 1;
            }
            node = node2;
            ++n;
        }
        node.addPositionFoundListener(positionFoundListener);
    }

    public Node getRootNode() {
        return this.nRoot;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void prepare() {
        Node node;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        this.nRoot.setFailure(null);
        int n = 0;
        while (n < 256) {
            node = this.nRoot.getTrans(n);
            if (node == null) {
                this.nRoot.setTrans(n, this.nRoot);
            } else {
                node.setFailure(this.nRoot);
                linkedList.addLast(node);
            }
            ++n;
        }
        while (!linkedList.isEmpty()) {
            node = (Node)linkedList.removeFirst();
            if (node.isLastNode()) continue;
            int n2 = 0;
            while (n2 < 256) {
                Node node2 = node.getTrans(n2);
                if (node2 == null) {
                    node.setTrans(n2, node.getFailure().getTrans(n2));
                } else {
                    node2.setFailure(node.getFailure().getTrans(n2));
                    linkedList.addLast(node2);
                }
                ++n2;
            }
        }
    }

    public int[] getNodeDepths() {
        return this.nodeDepthCount;
    }
}

