/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.openantivirus.scanner.PositionFoundEvent;
import org.openantivirus.scanner.PositionFoundListener;
import org.openantivirus.scanner.StringFinder;
import org.openantivirus.scanner.VirusFoundException;

public class StringVirusFinder {
    public static final String VERSION = "$Id: StringVirusFinder.java,v 1.7 2002/05/16 17:16:55 kurti Exp $";

    public StringVirusFinder(Reader reader, StringFinder stringFinder) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            int n = string.indexOf(61);
            if (n == -1) {
                System.err.println("Malformed pattern line: " + string);
                continue;
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            try {
                stringFinder.addString(this.hexToString(string3), new StringVirusFoundListener(string2));
            }
            catch (Exception exception) {
                System.err.println(string);
                exception.printStackTrace();
            }
        }
    }

    protected byte[] hexToString(String string) {
        if (string.length() % 2 != 0) {
            System.err.println("Malformed hexstring: " + string);
            return null;
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        while (n < string.length()) {
            byArray[n / 2] = (byte)Integer.parseInt(string.substring(n, n + 2), 16);
            n += 2;
        }
        return byArray;
    }

    private class StringVirusFoundListener
    implements PositionFoundListener {
        private String virusName;
        private String pattern;

        public StringVirusFoundListener(String string) {
            this.virusName = string;
        }

        public void positionFound(PositionFoundEvent positionFoundEvent) throws VirusFoundException {
            throw new VirusFoundException(this.virusName);
        }
    }
}

