/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner;

import org.openantivirus.scanner.PositionFoundEvent;
import org.openantivirus.scanner.PositionFoundListener;
import org.openantivirus.scanner.Trie;
import org.openantivirus.scanner.VirusFoundException;

public class StringFinder {
    public static final String VERSION = "$Id: StringFinder.java,v 1.2 2002/04/22 09:44:24 kurti Exp $";
    private Trie trie;

    public StringFinder(Trie trie) {
        this.trie = trie;
    }

    public void addString(byte[] byArray, PositionFoundListener positionFoundListener) {
        this.trie.addString(byArray, new PartialStringFoundListener(byArray, positionFoundListener));
    }

    private class PartialStringFoundListener
    implements PositionFoundListener {
        private byte[] abPattern;
        private PositionFoundListener pfl;

        public PartialStringFoundListener(byte[] byArray, PositionFoundListener positionFoundListener) {
            this.abPattern = byArray;
            this.pfl = positionFoundListener;
        }

        public void positionFound(PositionFoundEvent positionFoundEvent) throws VirusFoundException {
            byte[] byArray = positionFoundEvent.getBuffer();
            int n = positionFoundEvent.getOffset() + positionFoundEvent.getLength();
            int n2 = positionFoundEvent.getOffset() + positionFoundEvent.getLength() + positionFoundEvent.getPostfixLength();
            int n3 = positionFoundEvent.getLength();
            while (n3 < this.abPattern.length) {
                if ((n %= byArray.length) == n2) {
                    return;
                }
                if (this.abPattern[n3] != byArray[n]) {
                    return;
                }
                ++n;
                ++n3;
            }
            this.pfl.positionFound(positionFoundEvent);
        }
    }
}

