/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.openantivirus.credo.CredoException;
import org.openantivirus.credo.CredoParser;
import org.openantivirus.scanner.Node;
import org.openantivirus.scanner.RequestHandler;
import org.openantivirus.scanner.Scanner;
import org.openantivirus.scanner.ScannerConfiguration;
import org.openantivirus.scanner.Trie;

public class ScannerDaemon {
    public static final String VERSION = "$Id: ScannerDaemon.java,v 1.15 2002/10/16 11:01:44 kurti Exp $";
    public static final String REVISION = "0.5.2";
    public static final String BINDNAME = "localhost";
    public static final int PORT = 8127;
    private static final int MAX_BACKLOG = 50;
    private boolean isRunning;
    private final ScannerConfiguration scannerConfiguration;
    private final Scanner scanner;

    public ScannerDaemon(ScannerConfiguration scannerConfiguration) throws CredoException, IOException {
        this.scanner = new Scanner(scannerConfiguration);
        this.scannerConfiguration = scannerConfiguration;
        new CredoParser(scannerConfiguration).load();
        Trie trie = scannerConfiguration.getTrie();
        trie.prepare();
        System.out.println("Nodes: " + Node.getInstanceCount());
        int[] nArray = trie.getNodeDepths();
        int n = 0;
        while (n < nArray.length) {
            System.out.println(n + ": " + nArray[n]);
            ++n;
        }
    }

    public void start() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(8127, 50, InetAddress.getByName(BINDNAME));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.isRunning = true;
        while (this.isRunning) {
            try {
                new Thread(new RequestHandler(serverSocket.accept(), this.scanner)).start();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("OpenAntivirus ScannerDaemon v0.5.2\n(c) 2001-2002 iKu Netzwerkl\ufffdsungen http://www.iku-netz.de/\nScannerDaemon comes with ABSOLUTELY NO WARRANTY; for details read 'COPYING'.\nThis is free software, and you are welcome to redistribute it under certain\nconditions; for details read 'COPYING'.");
        ScannerConfiguration scannerConfiguration = new ScannerConfiguration();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) == '-') {
                String string = stringArray[n].substring(1);
                if ("nosignature".equals(string)) {
                    scannerConfiguration.setCredoLevel(-1);
                } else if ("credolevel".equals(string)) {
                    scannerConfiguration.setCredoLevel(Integer.parseInt(stringArray[++n]));
                } else if ("followsymlinks".equals(string)) {
                    scannerConfiguration.setFollowSymlinks(true);
                } else if ("tempdir".equals(string)) {
                    scannerConfiguration.setTempDirectory(new File(stringArray[++n]));
                } else {
                    System.err.println("Unknown parameter: " + stringArray[n]);
                }
            } else {
                scannerConfiguration.setCredoPath(stringArray[n]);
            }
            ++n;
        }
        try {
            new ScannerDaemon(scannerConfiguration).start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

