/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openantivirus.scanner.ScannerListener;
import org.openantivirus.scanner.Trie;
import org.openantivirus.scanner.VirusFoundException;

public class ScannerConfiguration {
    public static final String VERSION = "$Id: ScannerConfiguration.java,v 1.4 2002/05/20 13:10:35 kurti Exp $";
    private Trie trie = new Trie();
    private boolean followSymlinks = false;
    private int credoLevel = 3;
    private String credoPath = "credo";
    private File tempDirectory;
    private List listScannerListener = new ArrayList();

    public Trie getTrie() {
        return this.trie;
    }

    public boolean getFollowSymlinks() {
        return this.followSymlinks;
    }

    public synchronized void setFollowSymlinks(boolean bl) {
        this.followSymlinks = bl;
    }

    public int getCredoLevel() {
        return this.credoLevel;
    }

    public synchronized void setCredoLevel(int n) {
        this.credoLevel = n;
    }

    public String getCredoPath() {
        return this.credoPath;
    }

    public synchronized void setCredoPath(String string) {
        this.credoPath = string;
    }

    public synchronized Object clone() {
        ScannerConfiguration scannerConfiguration = new ScannerConfiguration();
        scannerConfiguration.followSymlinks = this.followSymlinks;
        scannerConfiguration.credoLevel = this.credoLevel;
        scannerConfiguration.credoPath = this.credoPath;
        scannerConfiguration.listScannerListener = this.listScannerListener;
        return scannerConfiguration;
    }

    public synchronized void setConfiguration(ScannerConfiguration scannerConfiguration) {
        this.followSymlinks = scannerConfiguration.followSymlinks;
        this.credoLevel = scannerConfiguration.credoLevel;
        this.credoPath = scannerConfiguration.credoPath;
        this.trie = scannerConfiguration.trie;
        this.listScannerListener = scannerConfiguration.listScannerListener;
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }

    public synchronized void setTempDirectory(File file) {
        this.tempDirectory = file;
    }

    public synchronized void addScannerListener(ScannerListener scannerListener) {
        this.listScannerListener.add(scannerListener);
    }

    public synchronized void removeScannerListener(ScannerListener scannerListener) {
        this.listScannerListener.remove(scannerListener);
    }

    public synchronized void fireVirusFoundException(VirusFoundException virusFoundException) {
        Iterator iterator = this.listScannerListener.iterator();
        while (iterator.hasNext()) {
            ((ScannerListener)iterator.next()).virusFound(virusFoundException);
        }
    }

    public synchronized void fireException(Exception exception) {
        Iterator iterator = this.listScannerListener.iterator();
        while (iterator.hasNext()) {
            ((ScannerListener)iterator.next()).exceptionThrown(exception);
        }
    }
}

