/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner;

import org.openantivirus.scanner.ScannerConfiguration;
import org.openantivirus.scanner.VirusFoundException;
import org.openantivirus.scanner.filter.DecompressFilterFactory;
import org.openantivirus.scanner.filter.ExecutableFilterFactory;
import org.openantivirus.scanner.filter.FileSystemFilterFactory;
import org.openantivirus.scanner.filter.Filter;
import org.openantivirus.scanner.filter.FilterFactory;
import org.openantivirus.scanner.filter.TrieScanFilter;
import org.openantivirus.scanner.filter.UninfectableFilterFactory;
import org.openantivirus.scanner.scanobject.ScanObject;

public class Scanner {
    public static final String VERSION = "$Id: Scanner.java,v 1.3 2002/05/20 13:10:35 kurti Exp $";
    private final FilterFactory[] filterFactories;
    private final ScannerConfiguration scannerConfiguration;

    public Scanner(ScannerConfiguration scannerConfiguration) {
        this.scannerConfiguration = scannerConfiguration;
        this.filterFactories = new FilterFactory[]{new FileSystemFilterFactory(scannerConfiguration), new UninfectableFilterFactory(), new ExecutableFilterFactory(scannerConfiguration), new DecompressFilterFactory()};
    }

    public void scan(ScanObject scanObject) throws VirusFoundException, Exception {
        Filter filter;
        int n = 0;
        while (n < this.filterFactories.length) {
            filter = this.filterFactories[n].getFilterFor(scanObject);
            if (filter != null) {
                this.doFilter(filter, scanObject);
                return;
            }
            ++n;
        }
        filter = new TrieScanFilter(this.scannerConfiguration.getTrie());
        this.doFilter(filter, scanObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doFilter(Filter filter, ScanObject scanObject) throws VirusFoundException, Exception {
        try {
            try {
                filter.filter(scanObject, this);
            }
            catch (VirusFoundException virusFoundException) {
                this.scannerConfiguration.fireVirusFoundException(virusFoundException);
                if (scanObject.getHaltOnVirusFound()) {
                    throw virusFoundException;
                }
                Object var6_4 = null;
                scanObject.dispose();
                return;
            }
            catch (Exception exception) {
                this.scannerConfiguration.fireException(exception);
                if (scanObject.getHaltOnError()) {
                    throw exception;
                }
                Object var6_5 = null;
                scanObject.dispose();
                return;
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            scanObject.dispose();
            throw throwable;
        }
        scanObject.dispose();
    }

    public ScannerConfiguration getScannerConfiguration() {
        return this.scannerConfiguration;
    }
}

