/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;
import org.openantivirus.credo.CredoParser;
import org.openantivirus.scanner.Scanner;
import org.openantivirus.scanner.ScannerConfiguration;
import org.openantivirus.scanner.SequentialStreamFilter;
import org.openantivirus.scanner.VirusFoundException;
import org.openantivirus.scanner.scanobject.FileScanObject;

public class RequestHandler
implements Runnable {
    public static final String VERSION = "$Id: RequestHandler.java,v 1.10 2002/05/20 13:10:35 kurti Exp $";
    public static final String OK = "OK\n";
    public static final String ERROR = "ERROR\n";
    private static final int DATA_TIMEOUT = 10000;
    private final Socket socket;
    private final ScannerConfiguration scannerConfiguration;
    private final Scanner scanner;

    public RequestHandler(Socket socket, Scanner scanner) {
        this.socket = socket;
        this.scanner = scanner;
        this.scannerConfiguration = scanner.getScannerConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String string = ERROR;
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            printWriter = new PrintWriter(this.socket.getOutputStream());
            StringTokenizer stringTokenizer = new StringTokenizer(bufferedReader.readLine());
            if (!stringTokenizer.hasMoreElements()) {
                System.err.println("No command found");
                return;
            }
            String string2 = stringTokenizer.nextToken().toUpperCase();
            try {
                if (string2.equals("SCAN")) {
                    if (!stringTokenizer.hasMoreElements()) {
                        System.err.println("Filename not found");
                        return;
                    }
                    this.scanner.scan(new FileScanObject(new File(stringTokenizer.nextToken())));
                    string = OK;
                    return;
                }
                if (string2.equals("POST")) {
                    ServerSocket serverSocket = new ServerSocket(0, 50, InetAddress.getByName("localhost"));
                    serverSocket.setSoTimeout(10000);
                    printWriter.println("Send data to port '" + serverSocket.getLocalPort() + "' within " + 10 + " seconds.");
                    printWriter.flush();
                    Socket socket = null;
                    try {
                        try {
                            socket = serverSocket.accept();
                            printWriter.println("Connected.");
                            printWriter.flush();
                            new SequentialStreamFilter(this.scannerConfiguration.getTrie()).filter(socket.getInputStream(), null);
                            string = OK;
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            string = ERROR;
                            Object var10_23 = null;
                            if (socket != null) {
                                socket.close();
                            }
                            serverSocket.close();
                            return;
                        }
                        Object var10_22 = null;
                        if (socket != null) {
                            socket.close();
                        }
                        serverSocket.close();
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var10_24 = null;
                        if (socket != null) {
                            socket.close();
                        }
                        serverSocket.close();
                        throw throwable;
                    }
                }
                if (string2.equals("FILTER")) {
                    ServerSocket serverSocket = new ServerSocket(0, 50, InetAddress.getByName("localhost"));
                    ServerSocket serverSocket2 = new ServerSocket(0, 50, InetAddress.getByName("localhost"));
                    serverSocket.setSoTimeout(10000);
                    serverSocket2.setSoTimeout(10000);
                    printWriter.println("Send/receive data to/from port '" + serverSocket.getLocalPort() + "/" + serverSocket2.getLocalPort() + "' within " + 10 + " seconds.");
                    printWriter.flush();
                    Socket socket = null;
                    Socket socket2 = null;
                    try {
                        socket = serverSocket.accept();
                        socket2 = serverSocket2.accept();
                        printWriter.println("Connected.");
                        printWriter.flush();
                        new SequentialStreamFilter(this.scannerConfiguration.getTrie()).filter(socket.getInputStream(), string2.equals("FILTER") ? socket2.getOutputStream() : null);
                        string = OK;
                        return;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        string = ERROR;
                        return;
                    }
                    finally {
                        if (socket2 != null) {
                            socket2.close();
                        }
                        if (socket != null) {
                            socket.close();
                        }
                        serverSocket.close();
                        serverSocket2.close();
                    }
                }
                if (string2.equals("COMMAND") && stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken().toUpperCase();
                    if (string3.equals("SHUTDOWN")) {
                        System.exit(0);
                        return;
                    }
                    if (!string3.equals("CREDO")) {
                        string = "ERROR\n: Unknown COMMAND '" + string3 + "'.";
                        return;
                    }
                    String string4 = stringTokenizer.nextToken().toUpperCase();
                    if (string4.equals("RELOAD")) {
                        ScannerConfiguration scannerConfiguration = (ScannerConfiguration)this.scannerConfiguration.clone();
                        new CredoParser(scannerConfiguration).load();
                        scannerConfiguration.getTrie().prepare();
                        this.scannerConfiguration.setConfiguration(scannerConfiguration);
                        string = OK;
                        return;
                    }
                    string = "ERROR\n: Unknown subcommand '" + string3 + "'.";
                    return;
                }
                string = "ERROR\n: Unknown command '" + string2 + "'.";
                return;
            }
            catch (VirusFoundException virusFoundException) {
                string = virusFoundException.getMessage() + "\n";
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        finally {
            try {
                if (printWriter != null) {
                    printWriter.write(string);
                    printWriter.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

