/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.scanner;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import org.openantivirus.scanner.RecursiveFileFilterListener;
import org.openantivirus.scanner.ScannerConfiguration;
import org.openantivirus.scanner.ScanningAbortedException;
import org.openantivirus.scanner.StreamFileFilter;
import org.openantivirus.scanner.VirusFoundException;

public class RecursiveFileFilter {
    public static final String VERSION = "$Id: RecursiveFileFilter.java,v 1.7 2002/05/20 13:10:35 kurti Exp $";
    private final StreamFileFilter sff;
    private final ScannerConfiguration scannerConfiguration;
    private transient ArrayList recursiveFileFilterListenerList;

    public RecursiveFileFilter(ScannerConfiguration scannerConfiguration, StreamFileFilter streamFileFilter) {
        this.sff = streamFileFilter;
        this.scannerConfiguration = scannerConfiguration;
    }

    public void filter(File file) throws VirusFoundException, IOException, ScanningAbortedException {
        if (!this.scannerConfiguration.getFollowSymlinks() && !file.getAbsolutePath().equals(file.getCanonicalPath())) {
            return;
        }
        this.fireScanning(file);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                throw new IOException("Cannot scan directory '" + file.getName() + "'");
            }
            int n = 0;
            while (n < fileArray.length) {
                this.filter(fileArray[n]);
                ++n;
            }
        } else {
            long l = System.currentTimeMillis();
            try {
                this.sff.filter(new RandomAccessFile(file, "r"));
            }
            catch (VirusFoundException virusFoundException) {
                virusFoundException.setFile(file);
                this.fireVirusFound(virusFoundException);
            }
        }
    }

    public synchronized void addRecursiveFileFilterListener(RecursiveFileFilterListener recursiveFileFilterListener) {
        if (this.recursiveFileFilterListenerList == null) {
            this.recursiveFileFilterListenerList = new ArrayList();
        }
        this.recursiveFileFilterListenerList.add(recursiveFileFilterListener);
    }

    public synchronized void removeRecursiveFileFilterListener(RecursiveFileFilterListener recursiveFileFilterListener) {
        if (this.recursiveFileFilterListenerList != null) {
            this.recursiveFileFilterListenerList.remove(recursiveFileFilterListener);
        }
    }

    protected synchronized void fireStartingScan() {
        if (this.recursiveFileFilterListenerList != null) {
            Iterator iterator = this.recursiveFileFilterListenerList.iterator();
            while (iterator.hasNext()) {
                ((RecursiveFileFilterListener)iterator.next()).startingScan();
            }
        }
    }

    protected synchronized void fireFinishedScan() {
        if (this.recursiveFileFilterListenerList != null) {
            Iterator iterator = this.recursiveFileFilterListenerList.iterator();
            while (iterator.hasNext()) {
                ((RecursiveFileFilterListener)iterator.next()).finishedScan();
            }
        }
    }

    protected synchronized void fireScanning(File file) throws ScanningAbortedException {
        if (this.recursiveFileFilterListenerList != null) {
            Iterator iterator = this.recursiveFileFilterListenerList.iterator();
            while (iterator.hasNext()) {
                ((RecursiveFileFilterListener)iterator.next()).scanning(file);
            }
        }
    }

    protected synchronized void fireVirusFound(VirusFoundException virusFoundException) throws VirusFoundException {
        if (this.recursiveFileFilterListenerList != null) {
            Iterator iterator = this.recursiveFileFilterListenerList.iterator();
            while (iterator.hasNext()) {
                ((RecursiveFileFilterListener)iterator.next()).virusFound(virusFoundException);
            }
        }
    }
}

