/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.credo;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.openantivirus.credo.CredoEntry;
import org.openantivirus.credo.CredoException;
import org.openantivirus.credo.CredoFile;
import org.openantivirus.credo.CredoVerifier;
import org.openantivirus.scanner.ScannerConfiguration;
import org.openantivirus.scanner.StringFinder;
import org.openantivirus.scanner.StringVirusFinder;

public class CredoParser {
    public static final String VERSION = "$Id: CredoParser.java,v 1.5 2002/04/23 08:54:00 kurti Exp $";
    public static final int NO_VERIFY = -1;
    public static final int DEFAULT_LEVEL = 3;
    private final ScannerConfiguration scannerConfiguration;

    public CredoParser(ScannerConfiguration scannerConfiguration) {
        this.scannerConfiguration = scannerConfiguration;
    }

    public void load() throws CredoException, IOException {
        this.parse(new File(this.scannerConfiguration.getCredoPath()));
    }

    public void parse(File file) throws CredoException, IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".credo");
                }
            });
            int n = 0;
            while (n < fileArray.length) {
                this.parse(fileArray[n]);
                ++n;
            }
        } else {
            this.doParse(new CredoFile(file));
        }
    }

    public void parse(InputStream inputStream) throws CredoException, IOException {
        this.doParse(new CredoFile(inputStream));
    }

    protected void doParse(CredoFile credoFile) throws CredoException, IOException {
        Iterator iterator = credoFile.entries();
        while (iterator.hasNext()) {
            CredoEntry credoEntry = (CredoEntry)iterator.next();
            System.out.println("Reading '" + credoEntry.getJarEntry().getName() + "'...");
            switch (credoEntry.getType()) {
                case 1: {
                    new StringVirusFinder(new InputStreamReader(credoEntry.getInputStream()), new StringFinder(this.scannerConfiguration.getTrie()));
                    break;
                }
                default: {
                    throw new CredoException("Unknown CredoEntry-type: " + credoEntry.getType());
                }
            }
            int n = this.scannerConfiguration.getCredoLevel();
            if (n == -1) continue;
            int n2 = CredoVerifier.verify(credoEntry);
            if (n2 < n) {
                throw new CredoException("Minimum Credo-level " + n + " > actual Credo-level " + n2);
            }
            System.out.println("  verified Credo-level " + n2);
        }
    }
}

