/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.openantivirus.engine.credo.WildcardPattern;

public class PatternOptimizer {
    static /* synthetic */ Class class$org$openantivirus$util$PatternOptimizer;

    public PatternOptimizer(String testFile, String patternFile) throws Exception {
        String line;
        int length;
        FileInputStream is = new FileInputStream(testFile);
        byte[] buffer = new byte[16384];
        int[] count = new int[65536];
        int[] used = new int[65536];
        System.err.println("Counting...");
        int match = ((InputStream)is).read() & 0xFF;
        while ((length = ((InputStream)is).read(buffer)) != -1) {
            for (int i = 0; i < length; ++i) {
                int n = match = (match << 8 | buffer[i] & 0xFF) & 0xFFFF;
                count[n] = count[n] + 1;
            }
        }
        ((InputStream)is).close();
        System.err.println("Optimizing...");
        int optimized = 0;
        int patterns = 0;
        int hits = 0;
        BufferedReader br = new BufferedReader(new FileReader(patternFile));
        while ((line = br.readLine()) != null) {
            ++patterns;
            int equalPos = line.indexOf("=");
            class PatternOffset {
                public int offset;
                public String pattern;

                public PatternOffset(int offset, String pattern) {
                    this.offset = offset;
                    this.pattern = pattern;
                }
            }
            LinkedList<PatternOffset> patternOffsets = new LinkedList<PatternOffset>();
            StringTokenizer st = new StringTokenizer(line.substring(equalPos + 1), "*");
            while (st.hasMoreTokens()) {
                String pattern = st.nextToken();
                WildcardPattern wp = new WildcardPattern(pattern);
                int min = Integer.MAX_VALUE;
                int minPos = 0;
                int pos = 0;
                int minTriple = 0;
                for (int j = 0; j < wp.skipList.length; ++j) {
                    int skipCount = wp.skipList[j];
                    if ((j & 1) == 0 && skipCount >= 2) {
                        match = wp.pattern[pos] & 0xFF;
                        for (int i = 1; i < skipCount; ++i) {
                            int tripleCount = count[match = (match << 8 | wp.pattern[i] & 0xFF) & 0xFFFF];
                            if (tripleCount > min) continue;
                            min = tripleCount;
                            minPos = pos + i;
                            minTriple = match;
                        }
                    }
                    pos += skipCount;
                }
                if (min == 0) {
                    ++optimized;
                } else {
                    hits += min;
                }
                patternOffsets.add(new PatternOffset(minPos, pattern));
                int n = minTriple;
                used[n] = used[n] + min;
            }
            System.out.print(line.substring(0, equalPos) + "[");
            boolean first = true;
            Iterator it = patternOffsets.iterator();
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    System.out.print('*');
                }
                System.out.print(((PatternOffset)it.next()).offset - 1);
            }
            System.out.print("]=");
            first = true;
            it = patternOffsets.iterator();
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    System.out.print('*');
                }
                System.out.print(((PatternOffset)it.next()).pattern.toUpperCase());
            }
            System.out.println();
        }
        br.close();
        System.err.println("Optimized: " + optimized + "/" + patterns);
        System.err.println("Hits: " + hits);
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: " + (class$org$openantivirus$util$PatternOptimizer == null ? (class$org$openantivirus$util$PatternOptimizer = PatternOptimizer.class$("org.openantivirus.util.PatternOptimizer")) : class$org$openantivirus$util$PatternOptimizer).getName() + " <test-file> <pattern-db>");
            System.exit(1);
        }
        try {
            new PatternOptimizer(args[0], args[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

