/*
 * Decompiled with CFR 0.152.
 */
package org.openantivirus.engine.credo;

import java.util.Iterator;
import java.util.LinkedList;

public class WildcardPattern {
    public final byte[] pattern;
    public final int[] skipList;
    private final String HEXDIGITS = "0123456789ABCDEF";

    public WildcardPattern(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Malformed hexstring: " + hex);
        }
        this.pattern = new byte[hex.length() / 2];
        LinkedList<Integer> colSkipList = new LinkedList<Integer>();
        int skipCount = 0;
        boolean skip = false;
        for (int i = 0; i < hex.length(); i += 2) {
            char c1 = hex.charAt(i);
            char c2 = hex.charAt(i + 1);
            if (c1 == '?' && c2 == '?') {
                if (skip) {
                    ++skipCount;
                    continue;
                }
                skip = true;
                colSkipList.add(new Integer(skipCount));
                skipCount = 1;
                continue;
            }
            if (!skip) {
                ++skipCount;
            } else {
                skip = false;
                colSkipList.add(new Integer(skipCount));
                skipCount = 1;
            }
            this.pattern[i / 2] = (byte)(("0123456789ABCDEF".indexOf(c1) << 4) + "0123456789ABCDEF".indexOf(c2));
        }
        if (skipCount > 0) {
            colSkipList.add(new Integer(skipCount));
        }
        this.skipList = new int[colSkipList.size()];
        Iterator it = colSkipList.iterator();
        for (int i = 0; i < this.skipList.length; ++i) {
            this.skipList[i] = (Integer)it.next();
        }
    }
}

